/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongGaugeData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

final class LongLastValueAggregator
extends AbstractAggregator<Long> {
    LongLastValueAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        super(resource, instrumentationLibraryInfo, descriptor, false);
    }

    @Override
    public AggregatorHandle<Long> createHandle() {
        return new Handle();
    }

    @Override
    public Long accumulateLong(long value) {
        return value;
    }

    @Override
    public Long merge(Long a1, Long a2) {
        return a2;
    }

    @Override
    public MetricData toMetricData(Map<Labels, Long> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createLongGauge(this.getResource(), this.getInstrumentationLibraryInfo(), this.getInstrumentDescriptor().getName(), this.getInstrumentDescriptor().getDescription(), this.getInstrumentDescriptor().getUnit(), LongGaugeData.create(MetricDataUtils.toLongPointList(accumulationByLabels, 0L, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Long> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);

        Handle() {
        }

        @Override
        protected Long doAccumulateThenReset() {
            return this.current.getAndSet(DEFAULT_VALUE);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

