/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.HistogramAccumulation;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.MinMaxSumCountAccumulation;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoublePointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongPointData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class MetricDataUtils {
    private MetricDataUtils() {
    }

    static List<LongPointData> toLongPointList(Map<Labels, Long> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<LongPointData> points = new ArrayList<LongPointData>(accumulationMap.size());
        for (Map.Entry<Labels, Long> entry : accumulationMap.entrySet()) {
            Labels labels = entry.getKey();
            Long accumulation = entry.getValue();
            points.add(LongPointData.create(startEpochNanos, epochNanos, labels, accumulation));
        }
        return points;
    }

    static List<DoublePointData> toDoublePointList(Map<Labels, Double> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<DoublePointData> points = new ArrayList<DoublePointData>(accumulationMap.size());
        for (Map.Entry<Labels, Double> entry : accumulationMap.entrySet()) {
            Labels labels = entry.getKey();
            Double accumulation = entry.getValue();
            points.add(DoublePointData.create(startEpochNanos, epochNanos, labels, accumulation));
        }
        return points;
    }

    static List<DoubleSummaryPointData> toDoubleSummaryPointList(Map<Labels, MinMaxSumCountAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<DoubleSummaryPointData> points = new ArrayList<DoubleSummaryPointData>(accumulationMap.size());
        for (Map.Entry<Labels, MinMaxSumCountAccumulation> entry : accumulationMap.entrySet()) {
            Labels labels = entry.getKey();
            MinMaxSumCountAccumulation aggregator = entry.getValue();
            points.add(aggregator.toPoint(startEpochNanos, epochNanos, labels));
        }
        return points;
    }

    static List<DoubleHistogramPointData> toDoubleHistogramPointList(Map<Labels, HistogramAccumulation> accumulationMap, long startEpochNanos, long epochNanos, List<Double> boundaries) {
        ArrayList<DoubleHistogramPointData> points = new ArrayList<DoubleHistogramPointData>(accumulationMap.size());
        for (Map.Entry<Labels, HistogramAccumulation> entry : accumulationMap.entrySet()) {
            Labels labels = entry.getKey();
            HistogramAccumulation aggregator = entry.getValue();
            ArrayList<Long> counts = new ArrayList<Long>(aggregator.getCounts().length);
            for (long v : aggregator.getCounts()) {
                counts.add(v);
            }
            points.add(DoubleHistogramPointData.create(startEpochNanos, epochNanos, labels, aggregator.getSum(), boundaries, counts));
        }
        return points;
    }
}

