/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.DoubleSumAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.LongSumAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;

final class SumAggregatorFactory
extends AggregatorFactory {
    private final AggregationTemporality temporality;

    SumAggregatorFactory(AggregationTemporality temporality) {
        this.temporality = temporality;
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongSumAggregator(resource, instrumentationLibraryInfo, descriptor, this.temporality);
            }
            case DOUBLE: {
                return new DoubleSumAggregator(resource, instrumentationLibraryInfo, descriptor, this.temporality);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

