/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.AttributeKey;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.Attributes;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.AttributesBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.BiConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class AttributesMap
extends Attributes {
    private static final long serialVersionUID = -5072696312123632376L;
    private final long capacity;
    private int totalAddedValues = 0;
    private final HashMap<AttributeKey<?>, Object> map = new HashMap();

    AttributesMap(long capacity) {
        this.capacity = capacity;
    }

    public <T> void put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey() == null || value == null) {
            return;
        }
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.map.containsKey(key)) {
            return;
        }
        this.map.put(key, value);
    }

    int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    @Override
    public <T> T get(AttributeKey<T> key) {
        return (T)this.map.get(key);
    }

    @Override
    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> consumer) {
        for (Map.Entry<AttributeKey<?>, Object> entry : this.map.entrySet()) {
            AttributeKey<?> key = entry.getKey();
            Object value = entry.getValue();
            consumer.accept(key, value);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Map<AttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll(this);
    }

    public String toString() {
        return "AttributesMap{data=" + super.toString() + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    Attributes immutableCopy() {
        return Attributes.builder().putAll(this).build();
    }
}

