/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.Tracer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TracerProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Function;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.Clock;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal.ComponentRegistry;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.IdGenerator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SdkTracer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SpanLimits;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.Supplier;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.TracerSharedState;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkTracerProvider
extends TracerProvider {
    private static final Logger logger = Logger.getLogger(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idsGenerator, Resource resource, Supplier<SpanLimits> spanLimitsSupplier, Sampler sampler, List<SpanProcessor> spanProcessors) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource, spanLimitsSupplier, sampler, spanProcessors);
        this.tracerSdkComponentRegistry = new ComponentRegistry<SdkTracer>(new Function<InstrumentationLibraryInfo, SdkTracer>(){

            @Override
            public SdkTracer apply(InstrumentationLibraryInfo instrumentationLibraryInfo) {
                return new SdkTracer(SdkTracerProvider.this.sharedState, instrumentationLibraryInfo);
            }
        });
    }

    @Override
    public Tracer get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    @Override
    public Tracer get(String instrumentationName, @Nullable String instrumentationVersion) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation name.");
            instrumentationName = DEFAULT_TRACER_NAME;
        }
        return this.tracerSdkComponentRegistry.get(instrumentationName, instrumentationVersion);
    }

    public SpanLimits getSpanLimits() {
        return this.sharedState.getSpanLimits();
    }

    public Sampler getSampler() {
        return this.sharedState.getSampler();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            logger.log(Level.WARNING, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

