/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.SpanData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export.MultiSpanExporter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export.NoopSpanExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class SpanExporter {
    public static SpanExporter composite(SpanExporter ... exporters) {
        return SpanExporter.composite(Arrays.asList(exporters));
    }

    public static SpanExporter composite(Iterable<SpanExporter> exporters) {
        ArrayList<SpanExporter> exportersList = new ArrayList<SpanExporter>();
        for (SpanExporter exporter : exporters) {
            exportersList.add(exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopSpanExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (SpanExporter)exportersList.get(0);
        }
        return MultiSpanExporter.create(exportersList);
    }

    public abstract CompletableResultCode export(Collection<SpanData> var1);

    public abstract CompletableResultCode flush();

    public abstract CompletableResultCode shutdown();

    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

