/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers;

import com.aliyun.openservices.ons.shaded.com.google.auto.value.AutoValue;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.Attributes;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanKind;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Context;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.LinkData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.AutoValue_TraceIdRatioBasedSampler;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class TraceIdRatioBasedSampler
extends Sampler {
    TraceIdRatioBasedSampler() {
    }

    static TraceIdRatioBasedSampler create(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("ratio must be in range [0.0, 1.0]");
        }
        long idUpperBound = ratio == 0.0 ? Long.MIN_VALUE : (ratio == 1.0 ? Long.MAX_VALUE : (long)(ratio * 9.223372036854776E18));
        return new AutoValue_TraceIdRatioBasedSampler(ratio, idUpperBound, SamplingResult.create(SamplingDecision.RECORD_AND_SAMPLE), SamplingResult.create(SamplingDecision.DROP));
    }

    abstract double getRatio();

    abstract long getIdUpperBound();

    abstract SamplingResult getPositiveSamplingResult();

    abstract SamplingResult getNegativeSamplingResult();

    @Override
    public final SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return Math.abs(TraceIdRatioBasedSampler.getTraceIdRandomPart(traceId)) < this.getIdUpperBound() ? this.getPositiveSamplingResult() : this.getNegativeSamplingResult();
    }

    @Override
    public final String getDescription() {
        return String.format("TraceIdRatioBased{%.6f}", this.getRatio());
    }

    public final String toString() {
        return this.getDescription();
    }

    private static long getTraceIdRandomPart(String traceId) {
        return OtelEncodingUtils.longFromBase16String(traceId, 16);
    }
}

