/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl;

import com.aliyun.openservices.ons.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.Client;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.ClientManager;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.ClientManagerImpl;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ClientManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientManagerFactory.class);
    private static final ClientManagerFactory INSTANCE = new ClientManagerFactory();
    @GuardedBy(value="managersTableLock")
    private final Map<String, ClientManagerImpl> managersTable = new HashMap<String, ClientManagerImpl>();
    private final Lock managersTableLock = new ReentrantLock();

    private ClientManagerFactory() {
    }

    public static ClientManagerFactory getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientManager registerClient(String managerId, Client client) {
        this.managersTableLock.lock();
        try {
            ClientManagerImpl manager = this.managersTable.get(managerId);
            if (null == manager) {
                manager = new ClientManagerImpl(managerId);
                manager.startAsync().awaitRunning();
                this.managersTable.put(managerId, manager);
            }
            manager.registerClient(client);
            ClientManagerImpl clientManagerImpl = manager;
            return clientManagerImpl;
        }
        finally {
            this.managersTableLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterClient(String managerId, Client client) {
        ClientManagerImpl removedManager = null;
        this.managersTableLock.lock();
        try {
            ClientManagerImpl manager = this.managersTable.get(managerId);
            if (null == manager) {
                log.error("[Bug] manager not found by managerId={}", (Object)managerId);
                boolean bl = false;
                return bl;
            }
            manager.unregisterClient(client);
            if (manager.isEmpty()) {
                removedManager = manager;
                this.managersTable.remove(managerId);
            }
        }
        finally {
            this.managersTableLock.unlock();
        }
        if (null != removedManager) {
            removedManager.stopAsync().awaitTerminated();
        }
        return null != removedManager;
    }
}

