/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Optional;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer.OffsetStore;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageQueue;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.ExecutorServices;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.ThreadFactoryImpl;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOffsetStore
implements OffsetStore {
    private static final Logger log = LoggerFactory.getLogger(AbstractOffsetStore.class);
    private final long persistPeriodSeconds;
    private final ConcurrentMap<MessageQueue, Long> offsetTable;
    private final ScheduledExecutorService offsetPersistScheduler;

    public AbstractOffsetStore(long persistPeriodSeconds) {
        this.persistPeriodSeconds = persistPeriodSeconds;
        this.offsetTable = new ConcurrentHashMap<MessageQueue, Long>();
        this.offsetPersistScheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("OffsetPersistScheduler"));
    }

    @Override
    public void start() {
        Map<MessageQueue, Long> queueOffsetTable = this.loadOffset();
        if (null != queueOffsetTable) {
            this.offsetTable.putAll(queueOffsetTable);
        }
        this.offsetPersistScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractOffsetStore.this.persistOffset(AbstractOffsetStore.this.offsetTable);
                }
                catch (Throwable t2) {
                    log.error("Exception occurs while trying to persist offset", t2);
                }
            }
        }, this.persistPeriodSeconds, this.persistPeriodSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        try {
            if (!ExecutorServices.awaitTerminated(this.offsetPersistScheduler)) {
                log.error("[Bug] Timeout to shutdown the offset persist scheduler.");
            }
        }
        catch (Throwable t2) {
            log.error("Failed to shutdown the offset persist scheduler.", t2);
        }
    }

    public abstract Map<MessageQueue, Long> loadOffset();

    public abstract void persistOffset(Map<MessageQueue, Long> var1);

    @Override
    public void updateOffset(MessageQueue mq, long offset) {
        this.offsetTable.put(mq, offset);
    }

    @Override
    public Optional<Long> readOffset(MessageQueue mq) {
        Long offset = (Long)this.offsetTable.get(mq);
        if (null == offset) {
            return Optional.absent();
        }
        return Optional.of(offset);
    }
}

