/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Optional;
import com.aliyun.openservices.ons.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer.OffsetRecord;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NextOffsetRecord {
    @GuardedBy(value="offsetRecordsLock")
    private final TreeSet<OffsetRecord> offsetRecords = new TreeSet();
    private final ReadWriteLock offsetRecordsLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<Long> offsetList) {
        this.offsetRecordsLock.writeLock().lock();
        try {
            for (long offset : offsetList) {
                OffsetRecord record;
                if (1 == this.offsetRecords.size() && (record = this.offsetRecords.iterator().next()).isReleased() && record.getOffset() < offset) {
                    this.offsetRecords.remove(record);
                }
                this.offsetRecords.add(new OffsetRecord(offset));
            }
        }
        finally {
            this.offsetRecordsLock.writeLock().unlock();
        }
    }

    public Optional<Long> next() {
        this.offsetRecordsLock.readLock().lock();
        try {
            if (this.offsetRecords.isEmpty()) {
                Optional<Long> optional = Optional.absent();
                return optional;
            }
            OffsetRecord record = this.offsetRecords.iterator().next();
            if (record.isReleased()) {
                Optional<Long> optional = Optional.of(1L + record.getOffset());
                return optional;
            }
            Optional<Long> optional = Optional.of(record.getOffset());
            return optional;
        }
        finally {
            this.offsetRecordsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List<Long> offsetList) {
        this.offsetRecordsLock.writeLock().lock();
        try {
            for (Long offset : offsetList) {
                OffsetRecord record = new OffsetRecord(offset);
                this.offsetRecords.remove(record);
                if (!this.offsetRecords.isEmpty()) continue;
                record.setReleased(true);
                this.offsetRecords.add(record);
            }
        }
        finally {
            this.offsetRecordsLock.writeLock().unlock();
        }
    }
}

