/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer;

import com.aliyun.openservices.ons.shaded.com.google.common.base.MoreObjects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer.Assignment;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageQueue;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Partition;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.TopicRouteData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TopicAssignments {
    private final List<Assignment> assignmentList = new ArrayList<Assignment>();

    public TopicAssignments(TopicRouteData topicRouteData) {
        List<Partition> partitions = topicRouteData.getPartitions();
        for (Partition partition : partitions) {
            if (0 != partition.getBroker().getId()) continue;
            MessageQueue mq = new MessageQueue(partition);
            Assignment assignment = new Assignment(mq);
            this.assignmentList.add(assignment);
        }
    }

    public TopicAssignments(List<apache.rocketmq.v1.Assignment> assignmentList) {
        for (apache.rocketmq.v1.Assignment item : assignmentList) {
            MessageQueue messageQueue = new MessageQueue(new Partition(item.getPartition()));
            this.assignmentList.add(new Assignment(messageQueue));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicAssignments that = (TopicAssignments)o;
        return Objects.equal(this.assignmentList, that.assignmentList);
    }

    public int hashCode() {
        return Objects.hashCode(this.assignmentList);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("assignmentList", this.assignmentList).toString();
    }

    public List<Assignment> getAssignmentList() {
        return this.assignmentList;
    }
}

