/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.producer;

import com.aliyun.openservices.ons.shaded.com.google.common.annotations.VisibleForTesting;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.com.google.common.collect.ImmutableCollection;
import com.aliyun.openservices.ons.shaded.com.google.common.collect.ImmutableList;
import com.aliyun.openservices.ons.shaded.com.google.common.math.IntMath;
import com.aliyun.openservices.ons.shaded.commons.lang3.RandomUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ClientException;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ErrorCode;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageQueue;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Broker;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Endpoints;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Partition;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.TopicRouteData;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SendingTopicRouteData {
    private static final Logger log = LoggerFactory.getLogger(SendingTopicRouteData.class);
    private final AtomicInteger index = new AtomicInteger(RandomUtils.nextInt());
    private final ImmutableList<Partition> partitions;

    public SendingTopicRouteData(TopicRouteData topicRouteData) {
        this.partitions = SendingTopicRouteData.filterPartition(topicRouteData);
    }

    public List<MessageQueue> getMessageQueues() {
        ArrayList<MessageQueue> messageQueues = new ArrayList<MessageQueue>();
        for (Partition partition : this.partitions) {
            messageQueues.add(new MessageQueue(partition));
        }
        return messageQueues;
    }

    @VisibleForTesting
    public static ImmutableList<Partition> filterPartition(TopicRouteData topicRouteData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Partition partition : topicRouteData.getPartitions()) {
            if (!partition.getPermission().isWritable() || 0 != partition.getBroker().getId()) continue;
            builder.add(partition);
        }
        ImmutableCollection partitions0 = builder.build();
        if (partitions0.isEmpty()) {
            log.warn("No available partition, topicRouteData={}", (Object)topicRouteData);
        }
        return partitions0;
    }

    public boolean isEmpty() {
        return this.partitions.isEmpty();
    }

    public List<Partition> takePartitions(Set<Endpoints> isolated, int count) throws ClientException {
        String brokerName;
        Broker broker;
        Partition partition;
        int i;
        int nextIndex = this.index.getAndIncrement();
        ArrayList<Partition> candidatePartitions = new ArrayList<Partition>();
        HashSet<String> candidateBrokerNames = new HashSet<String>();
        if (this.partitions.isEmpty()) {
            throw new ClientException(ErrorCode.NO_PERMISSION);
        }
        for (i = 0; i < this.partitions.size(); ++i) {
            partition = (Partition)this.partitions.get(IntMath.mod(nextIndex++, this.partitions.size()));
            broker = partition.getBroker();
            brokerName = broker.getName();
            if (!isolated.contains(broker.getEndpoints()) && !candidateBrokerNames.contains(brokerName)) {
                candidateBrokerNames.add(brokerName);
                candidatePartitions.add(partition);
            }
            if (candidatePartitions.size() < count) continue;
            return candidatePartitions;
        }
        if (candidatePartitions.isEmpty()) {
            for (i = 0; i < this.partitions.size(); ++i) {
                if (!candidateBrokerNames.contains(brokerName = (broker = (partition = (Partition)this.partitions.get(IntMath.mod(nextIndex++, this.partitions.size()))).getBroker()).getName())) {
                    candidateBrokerNames.add(brokerName);
                    candidatePartitions.add(partition);
                }
                if (candidatePartitions.size() >= count) break;
            }
        }
        return candidatePartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendingTopicRouteData that = (SendingTopicRouteData)o;
        return Objects.equal(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hashCode(this.partitions);
    }
}

