/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message;

import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.UtilAll;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageIdGenerator {
    private static final MessageIdGenerator INSTANCE = new MessageIdGenerator();
    private static final String VERSION = "01";
    private final String prefix;
    private final long secondsSinceCustomEpoch;
    private final long secondsStartTimestamp;
    private long seconds;
    private final AtomicInteger sequence;

    private MessageIdGenerator() {
        ByteBuffer prefixBuffer = ByteBuffer.allocate(8);
        prefixBuffer.order(ByteOrder.BIG_ENDIAN);
        byte[] prefix0 = UtilAll.macAddress();
        prefixBuffer.put(prefix0, 0, 6);
        ByteBuffer pidBuffer = ByteBuffer.allocate(4);
        pidBuffer.order(ByteOrder.BIG_ENDIAN);
        int pid = UtilAll.processId();
        pidBuffer.putInt(pid);
        prefixBuffer.put(pidBuffer.array(), 2, 2);
        prefixBuffer.flip();
        this.prefix = VERSION + UtilAll.encodeHexString(prefixBuffer, false);
        this.secondsSinceCustomEpoch = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.customEpochMillis());
        this.secondsStartTimestamp = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
        this.seconds = this.deltaSeconds();
        this.sequence = new AtomicInteger(0);
    }

    public static MessageIdGenerator getInstance() {
        return INSTANCE;
    }

    private long customEpochMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2021);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public String next() {
        ByteBuffer suffixBuffer = ByteBuffer.allocate(8);
        suffixBuffer.order(ByteOrder.BIG_ENDIAN);
        ByteBuffer deltaSecondsBuffer = ByteBuffer.allocate(8);
        deltaSecondsBuffer.order(ByteOrder.BIG_ENDIAN);
        long deltaSeconds = this.deltaSeconds();
        if (this.seconds != deltaSeconds) {
            this.seconds = deltaSeconds;
        }
        deltaSecondsBuffer.putLong(this.seconds);
        suffixBuffer.put(deltaSecondsBuffer.array(), 4, 4);
        suffixBuffer.putInt(this.sequence.getAndIncrement());
        suffixBuffer.flip();
        return this.prefix + UtilAll.encodeHexString(suffixBuffer, false);
    }

    private long deltaSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime()) - this.secondsStartTimestamp + this.secondsSinceCustomEpoch;
    }
}

