/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting;

import com.aliyun.openservices.ons.shaded.io.grpc.CallOptions;
import com.aliyun.openservices.ons.shaded.io.grpc.Channel;
import com.aliyun.openservices.ons.shaded.io.grpc.ClientCall;
import com.aliyun.openservices.ons.shaded.io.grpc.ClientInterceptor;
import com.aliyun.openservices.ons.shaded.io.grpc.ForwardingClientCall;
import com.aliyun.openservices.ons.shaded.io.grpc.ForwardingClientCallListener;
import com.aliyun.openservices.ons.shaded.io.grpc.Metadata;
import com.aliyun.openservices.ons.shaded.io.grpc.MethodDescriptor;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(listener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                    }

                    @Override
                    public void onMessage(RespT response) {
                        log.trace("gRPC response: {}\n{}", (Object)response.getClass().getName(), response);
                        super.onMessage(response);
                    }
                }, headers);
            }

            @Override
            public void sendMessage(ReqT request) {
                log.trace("gRPC request: {}\n{}", (Object)request.getClass().getName(), request);
                super.sendMessage(request);
            }
        };
    }
}

