/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting;

import apache.rocketmq.v1.AckMessageRequest;
import apache.rocketmq.v1.AckMessageResponse;
import apache.rocketmq.v1.EndTransactionRequest;
import apache.rocketmq.v1.EndTransactionResponse;
import apache.rocketmq.v1.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v1.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v1.HealthCheckRequest;
import apache.rocketmq.v1.HealthCheckResponse;
import apache.rocketmq.v1.HeartbeatRequest;
import apache.rocketmq.v1.HeartbeatResponse;
import apache.rocketmq.v1.MessagingServiceGrpc;
import apache.rocketmq.v1.NackMessageRequest;
import apache.rocketmq.v1.NackMessageResponse;
import apache.rocketmq.v1.NotifyClientTerminationRequest;
import apache.rocketmq.v1.NotifyClientTerminationResponse;
import apache.rocketmq.v1.PollCommandRequest;
import apache.rocketmq.v1.PollCommandResponse;
import apache.rocketmq.v1.PullMessageRequest;
import apache.rocketmq.v1.PullMessageResponse;
import apache.rocketmq.v1.QueryAssignmentRequest;
import apache.rocketmq.v1.QueryAssignmentResponse;
import apache.rocketmq.v1.QueryOffsetRequest;
import apache.rocketmq.v1.QueryOffsetResponse;
import apache.rocketmq.v1.QueryRouteRequest;
import apache.rocketmq.v1.QueryRouteResponse;
import apache.rocketmq.v1.ReceiveMessageRequest;
import apache.rocketmq.v1.ReceiveMessageResponse;
import apache.rocketmq.v1.ReportMessageConsumptionResultRequest;
import apache.rocketmq.v1.ReportMessageConsumptionResultResponse;
import apache.rocketmq.v1.ReportThreadStackTraceRequest;
import apache.rocketmq.v1.ReportThreadStackTraceResponse;
import apache.rocketmq.v1.SendMessageRequest;
import apache.rocketmq.v1.SendMessageResponse;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.aliyun.openservices.ons.shaded.grpc.netty.GrpcSslContexts;
import com.aliyun.openservices.ons.shaded.grpc.netty.NettyChannelBuilder;
import com.aliyun.openservices.ons.shaded.io.grpc.ClientInterceptor;
import com.aliyun.openservices.ons.shaded.io.grpc.ManagedChannel;
import com.aliyun.openservices.ons.shaded.io.grpc.Metadata;
import com.aliyun.openservices.ons.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.ons.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import com.aliyun.openservices.ons.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.aliyun.openservices.ons.shaded.io.grpc.stub.MetadataUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.IpNameResolverFactory;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.LoggingInterceptor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.RpcClient;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Endpoints;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public class RpcClientImpl
implements RpcClient {
    private static final long KEEP_ALIVE_TIME_SECONDS = 30L;
    private static final int GRPC_MAX_MESSAGE_SIZE = Integer.MAX_VALUE;
    private final ManagedChannel channel;
    private final MessagingServiceGrpc.MessagingServiceFutureStub stub;
    private long activityNanoTime;

    public RpcClientImpl(Endpoints endpoints) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        SslContext sslContext = builder.build();
        NettyChannelBuilder channelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget(endpoints.getFacade()).keepAliveTime(30L, TimeUnit.SECONDS).maxInboundMessageSize(Integer.MAX_VALUE).intercept(new ClientInterceptor[]{new LoggingInterceptor()})).sslContext(sslContext);
        channelBuilder.disableRetry();
        List<InetSocketAddress> socketAddresses = endpoints.toSocketAddresses();
        if (null != socketAddresses) {
            IpNameResolverFactory ipNameResolverFactory = new IpNameResolverFactory(socketAddresses);
            channelBuilder.nameResolverFactory(ipNameResolverFactory);
        }
        this.channel = channelBuilder.build();
        this.stub = MessagingServiceGrpc.newFutureStub(this.channel);
        this.activityNanoTime = System.nanoTime();
    }

    @Override
    public long idleSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.activityNanoTime);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public ListenableFuture<QueryRouteResponse> queryRoute(Metadata metadata, QueryRouteRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).queryRoute(request);
    }

    @Override
    public ListenableFuture<HeartbeatResponse> heartbeat(Metadata metadata, HeartbeatRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).heartbeat(request);
    }

    @Override
    public ListenableFuture<HealthCheckResponse> healthCheck(Metadata metadata, HealthCheckRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).healthCheck(request);
    }

    @Override
    public ListenableFuture<SendMessageResponse> sendMessage(Metadata metadata, SendMessageRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).sendMessage(request);
    }

    @Override
    public ListenableFuture<QueryAssignmentResponse> queryAssignment(Metadata metadata, QueryAssignmentRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).queryAssignment(request);
    }

    @Override
    public ListenableFuture<ReceiveMessageResponse> receiveMessage(Metadata metadata, ReceiveMessageRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).receiveMessage(request);
    }

    @Override
    public ListenableFuture<AckMessageResponse> ackMessage(Metadata metadata, AckMessageRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).ackMessage(request);
    }

    @Override
    public ListenableFuture<NackMessageResponse> nackMessage(Metadata metadata, NackMessageRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).nackMessage(request);
    }

    @Override
    public ListenableFuture<ForwardMessageToDeadLetterQueueResponse> forwardMessageToDeadLetterQueue(Metadata metadata, ForwardMessageToDeadLetterQueueRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).forwardMessageToDeadLetterQueue(request);
    }

    @Override
    public ListenableFuture<EndTransactionResponse> endTransaction(Metadata metadata, EndTransactionRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).endTransaction(request);
    }

    @Override
    public ListenableFuture<QueryOffsetResponse> queryOffset(Metadata metadata, QueryOffsetRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).queryOffset(request);
    }

    @Override
    public ListenableFuture<PullMessageResponse> pullMessage(Metadata metadata, PullMessageRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).pullMessage(request);
    }

    @Override
    public ListenableFuture<PollCommandResponse> pollCommand(Metadata metadata, PollCommandRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).pollCommand(request);
    }

    @Override
    public ListenableFuture<ReportThreadStackTraceResponse> reportThreadStackTrace(Metadata metadata, ReportThreadStackTraceRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).reportThreadStackTrace(request);
    }

    @Override
    public ListenableFuture<ReportMessageConsumptionResultResponse> reportMessageConsumptionResult(Metadata metadata, ReportMessageConsumptionResultRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).reportMessageConsumptionResult(request);
    }

    @Override
    public ListenableFuture<NotifyClientTerminationResponse> notifyClientTermination(Metadata metadata, NotifyClientTerminationRequest request, Executor executor, long duration, TimeUnit timeUnit) {
        this.activityNanoTime = System.nanoTime();
        return ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata))).withExecutor(executor)).withDeadlineAfter(duration, timeUnit)).notifyClientTermination(request);
    }
}

