/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route;

import apache.rocketmq.v1.Endpoints;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Preconditions;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Address;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.AddressScheme;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Endpoints {
    private static final String ADDRESS_SEPARATOR = ",";
    private final AddressScheme addressScheme;
    private final String facade;
    private final List<Address> addresses;

    public Endpoints(apache.rocketmq.v1.Endpoints endpoints) {
        this.addresses = new ArrayList<Address>();
        for (apache.rocketmq.v1.Address address : endpoints.getAddressesList()) {
            this.addresses.add(new Address(address));
        }
        if (this.addresses.isEmpty()) {
            throw new UnsupportedOperationException("No available address");
        }
        apache.rocketmq.v1.AddressScheme scheme = endpoints.getScheme();
        switch (scheme) {
            case IPv4: {
                this.addressScheme = AddressScheme.IPv4;
                break;
            }
            case IPv6: {
                this.addressScheme = AddressScheme.IPv6;
                break;
            }
            default: {
                this.addressScheme = AddressScheme.DOMAIN_NAME;
                if (this.addresses.size() <= 1) break;
                throw new UnsupportedOperationException("Multiple addresses not allowed in domain schema.");
            }
        }
        StringBuilder facadeBuilder = new StringBuilder();
        facadeBuilder.append(this.addressScheme.getPrefix());
        for (Address address : this.addresses) {
            facadeBuilder.append(address.getAddress()).append(ADDRESS_SEPARATOR);
        }
        this.facade = facadeBuilder.substring(0, facadeBuilder.length() - 1);
    }

    public Endpoints(AddressScheme addressScheme, List<Address> addresses) {
        if (AddressScheme.DOMAIN_NAME.equals((Object)addressScheme) && addresses.size() > 1) {
            throw new UnsupportedOperationException("Multiple addresses not allowed in domain schema.");
        }
        Preconditions.checkNotNull(addresses, "addresses");
        if (addresses.isEmpty()) {
            throw new UnsupportedOperationException("No available address");
        }
        this.addressScheme = addressScheme;
        this.addresses = addresses;
        StringBuilder facadeBuilder = new StringBuilder();
        facadeBuilder.append(addressScheme.getPrefix());
        for (Address address : addresses) {
            facadeBuilder.append(address.getAddress()).append(ADDRESS_SEPARATOR);
        }
        this.facade = facadeBuilder.substring(0, facadeBuilder.length() - 1);
    }

    public List<InetSocketAddress> toSocketAddresses() {
        switch (this.addressScheme) {
            case DOMAIN_NAME: {
                return null;
            }
        }
        ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>();
        for (Address address : this.addresses) {
            socketAddresses.add(new InetSocketAddress(address.getHost(), address.getPort()));
        }
        return socketAddresses;
    }

    public apache.rocketmq.v1.Endpoints toPbEndpoints() {
        Endpoints.Builder builder = apache.rocketmq.v1.Endpoints.newBuilder();
        for (Address address : this.addresses) {
            builder.addAddresses(address.toPbAddress());
        }
        return builder.setScheme(this.addressScheme.toAddressScheme()).build();
    }

    public String toString() {
        return this.facade;
    }

    public String getFacade() {
        return this.facade;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoints endpoints = (Endpoints)o;
        return this.addressScheme == endpoints.addressScheme && Objects.equal(this.facade, endpoints.facade) && Objects.equal(this.addresses, endpoints.addresses);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.addressScheme, this.facade, this.addresses});
    }
}

