/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.Span;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanContext;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanKind;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.StatusCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.Tracer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Context;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.MessageModel;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.ClientImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer.PushConsumerImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageHookPoint;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageImplAccessor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageInterceptor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageInterceptorContext;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.misc.MixAll;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.CredentialsProvider;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.MessageTracer;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.MessagingAttributes;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.RocketmqAttributes;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.RocketmqOperation;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.TracingUtility;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class TracingMessageInterceptor
implements MessageInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TracingMessageInterceptor.class);
    private static final String MESSAGING_SYSTEM = "rocketmq";
    private static final String MESSAGING_PROTOCOL_VALUE = "RMQ-gRPC";
    private final MessageTracer messageTracer;
    private final ConcurrentMap<String, Span> inflightSendSpans;
    private final ConcurrentMap<String, Span> inflightAwaitSpans;
    private final ThreadLocal<Span> processSpanThreadLocal;

    public TracingMessageInterceptor(MessageTracer messageTracer) {
        this.messageTracer = messageTracer;
        this.inflightSendSpans = new ConcurrentHashMap<String, Span>();
        this.inflightAwaitSpans = new ConcurrentHashMap<String, Span>();
        this.processSpanThreadLocal = new ThreadLocal();
    }

    public int getInflightSendSpanSize() {
        return this.inflightSendSpans.size();
    }

    public int getInflightAwaitSpanSize() {
        return this.inflightAwaitSpans.size();
    }

    private String getSpanName(String topic, RocketmqOperation operation) {
        return this.messageTracer.getClientImpl().getNamespace() + '/' + topic + " " + operation.getName();
    }

    private void addUniversalAttributes(RocketmqOperation operation, Span span, MessageInterceptorContext context) {
        ClientImpl clientImpl = this.messageTracer.getClientImpl();
        span.setAttribute(MessagingAttributes.MESSAGING_SYSTEM, MESSAGING_SYSTEM);
        span.setAttribute(MessagingAttributes.MESSAGING_DESTINATION, context.getTopic());
        span.setAttribute(MessagingAttributes.MESSAGING_DESTINATION_KIND, "topic");
        span.setAttribute(MessagingAttributes.MESSAGING_PROTOCOL, MESSAGING_PROTOCOL_VALUE);
        span.setAttribute(MessagingAttributes.MESSAGING_PROTOCOL_VERSION, MixAll.getProtocolVersion());
        span.setAttribute(MessagingAttributes.MESSAGING_URL, clientImpl.getNameServerStr());
        span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_NAMESPACE, clientImpl.getNamespace());
        span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_CLIENT_ID, clientImpl.getId());
        span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_CLIENT_GROUP, clientImpl.getGroup());
        span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_OPERATION, operation.getName());
        CredentialsProvider credentialsProvider = clientImpl.getCredentialsProvider();
        if (null == credentialsProvider) {
            return;
        }
        try {
            String accessKey = credentialsProvider.getCredentials().getAccessKey();
            span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_ACCESS_KEY, accessKey);
        }
        catch (Throwable t2) {
            log.warn("Failed to parse accessKey from credentials provider for tracing, clientId={}", (Object)clientImpl.getId(), (Object)t2);
        }
    }

    private void addMessageModelAttribute(Span span) {
        ClientImpl clientImpl = this.messageTracer.getClientImpl();
        if (clientImpl instanceof PushConsumerImpl) {
            PushConsumerImpl pushConsumer = (PushConsumerImpl)clientImpl;
            MessageModel messageModel = pushConsumer.getMessageModel();
            switch (messageModel) {
                case CLUSTERING: {
                    span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_CONSUMPTION_MODEL, MessageModel.CLUSTERING.getName());
                    break;
                }
                case BROADCASTING: {
                    span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_CONSUMPTION_MODEL, MessageModel.BROADCASTING.getName());
                    break;
                }
            }
        }
    }

    private void addMessageUniversalAttributes(Span span, MessageExt messageExt) {
        span.setAttribute(MessagingAttributes.MESSAGING_MESSAGE_ID, messageExt.getMsgId());
        span.setAttribute(MessagingAttributes.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES, messageExt.getBody().length);
        span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_MESSAGE_TAG, messageExt.getTag());
        List<String> keyList = MessageImplAccessor.getMessageImpl(messageExt).getSystemAttribute().getKeyList();
        if (!keyList.isEmpty()) {
            span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_MESSAGE_KEYS, keyList);
        }
        span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_MESSAGE_TYPE, messageExt.getMsgType().getName());
        long deliveryTimestamp = messageExt.getDeliveryTimestamp();
        if (deliveryTimestamp > 0L) {
            span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_DELIVERY_TIMESTAMP, Long.valueOf(deliveryTimestamp));
        }
    }

    private void interceptPreSendMessage(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        String sendSpanName = this.getSpanName(context.getTopic(), RocketmqOperation.SEND);
        Span span = tracer.spanBuilder(sendSpanName).setSpanKind(SpanKind.PRODUCER).startSpan();
        String traceContext = TracingUtility.injectSpanContextToTraceParent(span.getSpanContext());
        this.inflightSendSpans.put(traceContext, span);
        MessageImplAccessor.getMessageImpl(messageExt).getSystemAttribute().setTraceContext(traceContext);
    }

    private void interceptPostSendMessage(MessageExt messageExt, MessageInterceptorContext context) {
        String traceContext = messageExt.getTraceContext();
        Span span = (Span)this.inflightSendSpans.remove(traceContext);
        if (null != span) {
            this.addUniversalAttributes(RocketmqOperation.SEND, span, context);
            this.addMessageUniversalAttributes(span, messageExt);
            span.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_ATTEMPT, context.getAttempt());
            StatusCode statusCode = TracingUtility.convertToTraceStatus(context.getStatus());
            span.setStatus(statusCode);
            span.end();
        }
    }

    private void interceptPostCommitMessage(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        long endNanoTime = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long startNanoTime = endNanoTime - context.getTimeUnit().toNanos(context.getDuration());
        String commitSpanName = this.getSpanName(context.getTopic(), RocketmqOperation.COMMIT);
        SpanBuilder commitSpanBuilder = tracer.spanBuilder(commitSpanName).setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
        String traceContext = messageExt.getTraceContext();
        SpanContext sendSpanContext = TracingUtility.extractContextFromTraceParent(traceContext);
        if (sendSpanContext.isValid()) {
            commitSpanBuilder.setParent(Context.current().with(Span.wrap(sendSpanContext)));
        }
        Span commitSpan = commitSpanBuilder.setSpanKind(SpanKind.PRODUCER).startSpan();
        this.addUniversalAttributes(RocketmqOperation.COMMIT, commitSpan, context);
        this.addMessageUniversalAttributes(commitSpan, messageExt);
        StatusCode statusCode = TracingUtility.convertToTraceStatus(context.getStatus());
        commitSpan.setStatus(statusCode);
        commitSpan.end(endNanoTime, TimeUnit.NANOSECONDS);
    }

    private void interceptPostRollbackMessage(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        long endNanoTime = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long startNanoTime = endNanoTime - context.getTimeUnit().toNanos(context.getDuration());
        String rollbackSpanName = this.getSpanName(context.getTopic(), RocketmqOperation.ROLLBACK);
        SpanBuilder rollbackSpanBuilder = tracer.spanBuilder(rollbackSpanName).setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
        String traceContext = messageExt.getTraceContext();
        SpanContext sendSpanContext = TracingUtility.extractContextFromTraceParent(traceContext);
        if (sendSpanContext.isValid()) {
            rollbackSpanBuilder.setParent(Context.current().with(Span.wrap(sendSpanContext)));
        }
        Span rollbackSpan = rollbackSpanBuilder.setSpanKind(SpanKind.PRODUCER).startSpan();
        this.addUniversalAttributes(RocketmqOperation.ROLLBACK, rollbackSpan, context);
        this.addMessageUniversalAttributes(rollbackSpan, messageExt);
        StatusCode statusCode = TracingUtility.convertToTraceStatus(context.getStatus());
        rollbackSpan.setStatus(statusCode);
        rollbackSpan.end(endNanoTime, TimeUnit.NANOSECONDS);
    }

    private void interceptPostPull(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        long endNanoTime = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long startNanoTime = endNanoTime - context.getTimeUnit().toNanos(context.getDuration());
        String pullSpanName = this.getSpanName(context.getTopic(), RocketmqOperation.PULL);
        SpanBuilder pullSpanBuilder = tracer.spanBuilder(pullSpanName).setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
        Span pullSpan = pullSpanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(pullSpan);
        pullSpan.setAttribute(MessagingAttributes.MESSAGING_OPERATION, "receive");
        this.addUniversalAttributes(RocketmqOperation.PULL, pullSpan, context);
        pullSpan.setStatus(TracingUtility.convertToTraceStatus(context.getStatus()));
        pullSpan.end(endNanoTime, TimeUnit.NANOSECONDS);
        if (null == messageExt) {
            return;
        }
        String traceContext = messageExt.getTraceContext();
        SpanContext spanContext = TracingUtility.extractContextFromTraceParent(traceContext);
        String awaitSpanName = this.getSpanName(messageExt.getTopic(), RocketmqOperation.AWAIT);
        SpanBuilder awaitSpanBuilder = tracer.spanBuilder(awaitSpanName);
        if (spanContext.isValid()) {
            awaitSpanBuilder.setParent(Context.current().with(Span.wrap(spanContext)));
        }
        awaitSpanBuilder.addLink(pullSpan.getSpanContext());
        Span awaitSpan = awaitSpanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(awaitSpan);
        MessageImpl messageImpl = MessageImplAccessor.getMessageImpl(messageExt);
        String awaitTraceContext = TracingUtility.injectSpanContextToTraceParent(awaitSpan.getSpanContext());
        messageImpl.getSystemAttribute().setTraceContext(awaitTraceContext);
        this.inflightAwaitSpans.put(awaitTraceContext, awaitSpan);
    }

    private void interceptPostReceive(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        long endNanoTime = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long startNanoTime = endNanoTime - context.getTimeUnit().toNanos(context.getDuration());
        String receiveSpanName = this.getSpanName(context.getTopic(), RocketmqOperation.RECEIVE);
        SpanBuilder receiveSpanBuilder = tracer.spanBuilder(receiveSpanName).setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
        Span receiveSpan = receiveSpanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(receiveSpan);
        receiveSpan.setAttribute(MessagingAttributes.MESSAGING_OPERATION, "receive");
        this.addUniversalAttributes(RocketmqOperation.RECEIVE, receiveSpan, context);
        receiveSpan.setStatus(TracingUtility.convertToTraceStatus(context.getStatus()));
        receiveSpan.end(endNanoTime, TimeUnit.NANOSECONDS);
        if (null == messageExt) {
            return;
        }
        String traceContext = messageExt.getTraceContext();
        SpanContext spanContext = TracingUtility.extractContextFromTraceParent(traceContext);
        String awaitSpanName = this.getSpanName(messageExt.getTopic(), RocketmqOperation.AWAIT);
        SpanBuilder awaitSpanBuilder = tracer.spanBuilder(awaitSpanName);
        if (spanContext.isValid()) {
            awaitSpanBuilder.setParent(Context.current().with(Span.wrap(spanContext)));
        }
        awaitSpanBuilder.addLink(receiveSpan.getSpanContext());
        Span awaitSpan = awaitSpanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(awaitSpan);
        MessageImpl messageImpl = MessageImplAccessor.getMessageImpl(messageExt);
        String awaitTraceContext = TracingUtility.injectSpanContextToTraceParent(awaitSpan.getSpanContext());
        messageImpl.getSystemAttribute().setTraceContext(awaitTraceContext);
        this.inflightAwaitSpans.put(awaitTraceContext, awaitSpan);
    }

    private void interceptPreMessageConsumption(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        String awaitTraceContext = messageExt.getTraceContext();
        Span awaitSpan = (Span)this.inflightAwaitSpans.remove(awaitTraceContext);
        if (null != awaitSpan) {
            awaitSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_AVAILABLE_TIMESTAMP, Long.valueOf(messageExt.getStoreTimestamp()));
            this.addUniversalAttributes(RocketmqOperation.AWAIT, awaitSpan, context);
            this.addMessageUniversalAttributes(awaitSpan, messageExt);
            awaitSpan.end();
        }
        SpanContext awaitSpanContext = TracingUtility.extractContextFromTraceParent(awaitTraceContext);
        String processSpanName = this.getSpanName(messageExt.getTopic(), RocketmqOperation.PROCESS);
        SpanBuilder spanBuilder = tracer.spanBuilder(processSpanName);
        if (awaitSpanContext.isValid()) {
            spanBuilder.setParent(Context.current().with(Span.wrap(awaitSpanContext)));
        }
        Span processSpan = spanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(processSpan);
        String processTraceSpan = TracingUtility.injectSpanContextToTraceParent(processSpan.getSpanContext());
        MessageImpl messageImpl = MessageImplAccessor.getMessageImpl(messageExt);
        messageImpl.getSystemAttribute().setTraceContext(processTraceSpan);
        this.processSpanThreadLocal.set(processSpan);
    }

    private void interceptPostMessageConsumption(MessageExt messageExt, MessageInterceptorContext context) {
        Span processSpan = this.processSpanThreadLocal.get();
        if (null == processSpan) {
            return;
        }
        this.processSpanThreadLocal.remove();
        processSpan.setAttribute(MessagingAttributes.MESSAGING_OPERATION, "process");
        processSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_ATTEMPT, context.getAttempt());
        processSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_AVAILABLE_TIMESTAMP, Long.valueOf(messageExt.getStoreTimestamp()));
        processSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_BATCH_SIZE, context.getBatchSize());
        this.addUniversalAttributes(RocketmqOperation.PROCESS, processSpan, context);
        this.addMessageUniversalAttributes(processSpan, messageExt);
        processSpan.setStatus(TracingUtility.convertToTraceStatus(context.getStatus()));
        processSpan.end();
    }

    private void interceptPostAckMessage(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        long endNanoTime = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long startNanoTime = endNanoTime - context.getTimeUnit().toNanos(context.getDuration());
        String ackSpanName = this.getSpanName(messageExt.getTopic(), RocketmqOperation.ACK);
        SpanBuilder ackSpanBuilder = tracer.spanBuilder(ackSpanName).setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
        String processTraceContext = messageExt.getTraceContext();
        SpanContext processSpanContext = TracingUtility.extractContextFromTraceParent(processTraceContext);
        if (processSpanContext.isValid()) {
            ackSpanBuilder.setParent(Context.current().with(Span.wrap(processSpanContext)));
        }
        Span ackSpan = ackSpanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(ackSpan);
        ackSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_ATTEMPT, context.getAttempt());
        ackSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_AVAILABLE_TIMESTAMP, Long.valueOf(messageExt.getStoreTimestamp()));
        this.addUniversalAttributes(RocketmqOperation.ACK, ackSpan, context);
        this.addMessageUniversalAttributes(ackSpan, messageExt);
        StatusCode statusCode = TracingUtility.convertToTraceStatus(context.getStatus());
        ackSpan.setStatus(statusCode);
        ackSpan.end(endNanoTime, TimeUnit.NANOSECONDS);
    }

    private void interceptPostNackMessage(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        long endNanoTime = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long startNanoTime = endNanoTime - context.getTimeUnit().toNanos(context.getDuration());
        String nackSpanName = this.getSpanName(messageExt.getTopic(), RocketmqOperation.NACK);
        SpanBuilder nackSpanBuilder = tracer.spanBuilder(nackSpanName).setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
        String processTraceContext = messageExt.getTraceContext();
        SpanContext processSpanContext = TracingUtility.extractContextFromTraceParent(processTraceContext);
        if (processSpanContext.isValid()) {
            nackSpanBuilder.setParent(Context.current().with(Span.wrap(processSpanContext)));
        }
        Span nackSpan = nackSpanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(nackSpan);
        nackSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_AVAILABLE_TIMESTAMP, Long.valueOf(messageExt.getStoreTimestamp()));
        this.addUniversalAttributes(RocketmqOperation.NACK, nackSpan, context);
        this.addMessageUniversalAttributes(nackSpan, messageExt);
        StatusCode statusCode = TracingUtility.convertToTraceStatus(context.getStatus());
        nackSpan.setStatus(statusCode);
        nackSpan.end(endNanoTime, TimeUnit.NANOSECONDS);
    }

    private void interceptPostForwardMessageToDLQ(Tracer tracer, MessageExt messageExt, MessageInterceptorContext context) {
        long endNanoTime = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        long startNanoTime = endNanoTime - context.getTimeUnit().toNanos(context.getDuration());
        String dlqSpanName = this.getSpanName(messageExt.getTopic(), RocketmqOperation.DLQ);
        SpanBuilder dlqSpanBuilder = tracer.spanBuilder(dlqSpanName).setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
        String processTraceContext = messageExt.getTraceContext();
        SpanContext processSpanContext = TracingUtility.extractContextFromTraceParent(processTraceContext);
        if (processSpanContext.isValid()) {
            dlqSpanBuilder.setParent(Context.current().with(Span.wrap(processSpanContext)));
        }
        Span dlqSpan = dlqSpanBuilder.setSpanKind(SpanKind.CONSUMER).startSpan();
        this.addMessageModelAttribute(dlqSpan);
        dlqSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_ATTEMPT, context.getAttempt());
        dlqSpan.setAttribute(RocketmqAttributes.MESSAGING_ROCKETMQ_AVAILABLE_TIMESTAMP, Long.valueOf(messageExt.getStoreTimestamp()));
        this.addUniversalAttributes(RocketmqOperation.DLQ, dlqSpan, context);
        this.addMessageUniversalAttributes(dlqSpan, messageExt);
        StatusCode statusCode = TracingUtility.convertToTraceStatus(context.getStatus());
        dlqSpan.setStatus(statusCode);
        dlqSpan.end(endNanoTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void intercept(MessageHookPoint hookPoint, MessageExt message, MessageInterceptorContext context) {
        Tracer tracer = this.messageTracer.getTracer();
        if (null == tracer) {
            return;
        }
        switch (hookPoint) {
            case PRE_SEND_MESSAGE: {
                this.interceptPreSendMessage(tracer, message, context);
                break;
            }
            case POST_SEND_MESSAGE: {
                this.interceptPostSendMessage(message, context);
                break;
            }
            case POST_COMMIT_MESSAGE: {
                this.interceptPostCommitMessage(tracer, message, context);
                break;
            }
            case POST_ROLLBACK_MESSAGE: {
                this.interceptPostRollbackMessage(tracer, message, context);
                break;
            }
            case POST_PULL: {
                this.interceptPostPull(tracer, message, context);
                break;
            }
            case POST_RECEIVE: {
                this.interceptPostReceive(tracer, message, context);
                break;
            }
            case PRE_MESSAGE_CONSUMPTION: {
                this.interceptPreMessageConsumption(tracer, message, context);
                break;
            }
            case POST_MESSAGE_CONSUMPTION: {
                this.interceptPostMessageConsumption(message, context);
                break;
            }
            case POST_ACK_MESSAGE: {
                this.interceptPostAckMessage(tracer, message, context);
                break;
            }
            case POST_NACK_MESSAGE: {
                this.interceptPostNackMessage(tracer, message, context);
                break;
            }
            case POST_FORWARD_MESSAGE_TO_DLQ: {
                this.interceptPostForwardMessageToDLQ(tracer, message, context);
                break;
            }
        }
    }
}

