/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/context.proto

package com.aliyun.openservices.ons.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * A context rule provides information about the context for an individual API
 * element.
 * </pre>
 *
 * Protobuf type {@code google.api.ContextRule}
 */
public final class ContextRule extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.ContextRule)
    ContextRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ContextRule.newBuilder() to construct.
  private ContextRule(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContextRule() {
    selector_ = "";
    requested_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
    provided_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
    allowedRequestExtensions_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
    allowedResponseExtensions_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContextRule();
  }

  @java.lang.Override
  public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ContextRule(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              selector_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                requested_ = new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              requested_.add(s);
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                provided_ = new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              provided_.add(s);
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                allowedRequestExtensions_ = new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              allowedRequestExtensions_.add(s);
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                allowedResponseExtensions_ = new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              allowedResponseExtensions_.add(s);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        requested_ = requested_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        provided_ = provided_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        allowedRequestExtensions_ = allowedRequestExtensions_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        allowedResponseExtensions_ = allowedResponseExtensions_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.aliyun.openservices.ons.shaded.com.google.api.ContextProto.internal_static_google_api_ContextRule_descriptor;
  }

  @java.lang.Override
  protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.aliyun.openservices.ons.shaded.com.google.api.ContextProto.internal_static_google_api_ContextRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.aliyun.openservices.ons.shaded.com.google.api.ContextRule.class, com.aliyun.openservices.ons.shaded.com.google.api.ContextRule.Builder.class);
  }

  public static final int SELECTOR_FIELD_NUMBER = 1;
  private volatile java.lang.Object selector_;
  /**
   *
   *
   * <pre>
   * Selects the methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The selector.
   */
  @java.lang.Override
  public java.lang.String getSelector() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Selects the methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The bytes for selector.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getSelectorBytes() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selector_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUESTED_FIELD_NUMBER = 2;
  private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList requested_;
  /**
   *
   *
   * <pre>
   * A list of full type names of requested contexts.
   * </pre>
   *
   * <code>repeated string requested = 2;</code>
   *
   * @return A list containing the requested.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getRequestedList() {
    return requested_;
  }
  /**
   *
   *
   * <pre>
   * A list of full type names of requested contexts.
   * </pre>
   *
   * <code>repeated string requested = 2;</code>
   *
   * @return The count of requested.
   */
  public int getRequestedCount() {
    return requested_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of full type names of requested contexts.
   * </pre>
   *
   * <code>repeated string requested = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The requested at the given index.
   */
  public java.lang.String getRequested(int index) {
    return requested_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of full type names of requested contexts.
   * </pre>
   *
   * <code>repeated string requested = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requested at the given index.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getRequestedBytes(int index) {
    return requested_.getByteString(index);
  }

  public static final int PROVIDED_FIELD_NUMBER = 3;
  private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList provided_;
  /**
   *
   *
   * <pre>
   * A list of full type names of provided contexts.
   * </pre>
   *
   * <code>repeated string provided = 3;</code>
   *
   * @return A list containing the provided.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getProvidedList() {
    return provided_;
  }
  /**
   *
   *
   * <pre>
   * A list of full type names of provided contexts.
   * </pre>
   *
   * <code>repeated string provided = 3;</code>
   *
   * @return The count of provided.
   */
  public int getProvidedCount() {
    return provided_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of full type names of provided contexts.
   * </pre>
   *
   * <code>repeated string provided = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The provided at the given index.
   */
  public java.lang.String getProvided(int index) {
    return provided_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of full type names of provided contexts.
   * </pre>
   *
   * <code>repeated string provided = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the provided at the given index.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getProvidedBytes(int index) {
    return provided_.getByteString(index);
  }

  public static final int ALLOWED_REQUEST_EXTENSIONS_FIELD_NUMBER = 4;
  private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList allowedRequestExtensions_;
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from client to backend.
   * </pre>
   *
   * <code>repeated string allowed_request_extensions = 4;</code>
   *
   * @return A list containing the allowedRequestExtensions.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getAllowedRequestExtensionsList() {
    return allowedRequestExtensions_;
  }
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from client to backend.
   * </pre>
   *
   * <code>repeated string allowed_request_extensions = 4;</code>
   *
   * @return The count of allowedRequestExtensions.
   */
  public int getAllowedRequestExtensionsCount() {
    return allowedRequestExtensions_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from client to backend.
   * </pre>
   *
   * <code>repeated string allowed_request_extensions = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedRequestExtensions at the given index.
   */
  public java.lang.String getAllowedRequestExtensions(int index) {
    return allowedRequestExtensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from client to backend.
   * </pre>
   *
   * <code>repeated string allowed_request_extensions = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedRequestExtensions at the given index.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getAllowedRequestExtensionsBytes(int index) {
    return allowedRequestExtensions_.getByteString(index);
  }

  public static final int ALLOWED_RESPONSE_EXTENSIONS_FIELD_NUMBER = 5;
  private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList allowedResponseExtensions_;
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from backend to client.
   * </pre>
   *
   * <code>repeated string allowed_response_extensions = 5;</code>
   *
   * @return A list containing the allowedResponseExtensions.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getAllowedResponseExtensionsList() {
    return allowedResponseExtensions_;
  }
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from backend to client.
   * </pre>
   *
   * <code>repeated string allowed_response_extensions = 5;</code>
   *
   * @return The count of allowedResponseExtensions.
   */
  public int getAllowedResponseExtensionsCount() {
    return allowedResponseExtensions_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from backend to client.
   * </pre>
   *
   * <code>repeated string allowed_response_extensions = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedResponseExtensions at the given index.
   */
  public java.lang.String getAllowedResponseExtensions(int index) {
    return allowedResponseExtensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of full type names or extension IDs of extensions allowed in grpc
   * side channel from backend to client.
   * </pre>
   *
   * <code>repeated string allowed_response_extensions = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedResponseExtensions at the given index.
   */
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getAllowedResponseExtensionsBytes(int index) {
    return allowedResponseExtensions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, selector_);
    }
    for (int i = 0; i < requested_.size(); i++) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requested_.getRaw(i));
    }
    for (int i = 0; i < provided_.size(); i++) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 3, provided_.getRaw(i));
    }
    for (int i = 0; i < allowedRequestExtensions_.size(); i++) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, allowedRequestExtensions_.getRaw(i));
    }
    for (int i = 0; i < allowedResponseExtensions_.size(); i++) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, allowedResponseExtensions_.getRaw(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, selector_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requested_.size(); i++) {
        dataSize += computeStringSizeNoTag(requested_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRequestedList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < provided_.size(); i++) {
        dataSize += computeStringSizeNoTag(provided_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getProvidedList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowedRequestExtensions_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedRequestExtensions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAllowedRequestExtensionsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowedResponseExtensions_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedResponseExtensions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAllowedResponseExtensionsList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.ContextRule)) {
      return super.equals(obj);
    }
    com.aliyun.openservices.ons.shaded.com.google.api.ContextRule other = (com.aliyun.openservices.ons.shaded.com.google.api.ContextRule) obj;

    if (!getSelector().equals(other.getSelector())) return false;
    if (!getRequestedList().equals(other.getRequestedList())) return false;
    if (!getProvidedList().equals(other.getProvidedList())) return false;
    if (!getAllowedRequestExtensionsList().equals(other.getAllowedRequestExtensionsList()))
      return false;
    if (!getAllowedResponseExtensionsList().equals(other.getAllowedResponseExtensionsList()))
      return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getSelector().hashCode();
    if (getRequestedCount() > 0) {
      hash = (37 * hash) + REQUESTED_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedList().hashCode();
    }
    if (getProvidedCount() > 0) {
      hash = (37 * hash) + PROVIDED_FIELD_NUMBER;
      hash = (53 * hash) + getProvidedList().hashCode();
    }
    if (getAllowedRequestExtensionsCount() > 0) {
      hash = (37 * hash) + ALLOWED_REQUEST_EXTENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedRequestExtensionsList().hashCode();
    }
    if (getAllowedResponseExtensionsCount() > 0) {
      hash = (37 * hash) + ALLOWED_RESPONSE_EXTENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedResponseExtensionsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(java.nio.ByteBuffer data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(
      java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(byte[] data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(
      byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseDelimitedFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.ContextRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A context rule provides information about the context for an individual API
   * element.
   * </pre>
   *
   * Protobuf type {@code google.api.ContextRule}
   */
  public static final class Builder extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.ContextRule)
      com.aliyun.openservices.ons.shaded.com.google.api.ContextRuleOrBuilder {
    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.ContextProto.internal_static_google_api_ContextRule_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.ContextProto.internal_static_google_api_ContextRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.ContextRule.class, com.aliyun.openservices.ons.shaded.com.google.api.ContextRule.Builder.class);
    }

    // Construct using com.aliyun.openservices.ons.shaded.com.google.api.ContextRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      selector_ = "";

      requested_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      provided_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      allowedRequestExtensions_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      allowedResponseExtensions_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.ContextProto.internal_static_google_api_ContextRule_descriptor;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.ContextRule getDefaultInstanceForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.ContextRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.ContextRule build() {
      com.aliyun.openservices.ons.shaded.com.google.api.ContextRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.ContextRule buildPartial() {
      com.aliyun.openservices.ons.shaded.com.google.api.ContextRule result = new com.aliyun.openservices.ons.shaded.com.google.api.ContextRule(this);
      int from_bitField0_ = bitField0_;
      result.selector_ = selector_;
      if (((bitField0_ & 0x00000001) != 0)) {
        requested_ = requested_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.requested_ = requested_;
      if (((bitField0_ & 0x00000002) != 0)) {
        provided_ = provided_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.provided_ = provided_;
      if (((bitField0_ & 0x00000004) != 0)) {
        allowedRequestExtensions_ = allowedRequestExtensions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.allowedRequestExtensions_ = allowedRequestExtensions_;
      if (((bitField0_ & 0x00000008) != 0)) {
        allowedResponseExtensions_ = allowedResponseExtensions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.allowedResponseExtensions_ = allowedResponseExtensions_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
      if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.ContextRule) {
        return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.ContextRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.ContextRule other) {
      if (other == com.aliyun.openservices.ons.shaded.com.google.api.ContextRule.getDefaultInstance()) return this;
      if (!other.getSelector().isEmpty()) {
        selector_ = other.selector_;
        onChanged();
      }
      if (!other.requested_.isEmpty()) {
        if (requested_.isEmpty()) {
          requested_ = other.requested_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRequestedIsMutable();
          requested_.addAll(other.requested_);
        }
        onChanged();
      }
      if (!other.provided_.isEmpty()) {
        if (provided_.isEmpty()) {
          provided_ = other.provided_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureProvidedIsMutable();
          provided_.addAll(other.provided_);
        }
        onChanged();
      }
      if (!other.allowedRequestExtensions_.isEmpty()) {
        if (allowedRequestExtensions_.isEmpty()) {
          allowedRequestExtensions_ = other.allowedRequestExtensions_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureAllowedRequestExtensionsIsMutable();
          allowedRequestExtensions_.addAll(other.allowedRequestExtensions_);
        }
        onChanged();
      }
      if (!other.allowedResponseExtensions_.isEmpty()) {
        if (allowedResponseExtensions_.isEmpty()) {
          allowedResponseExtensions_ = other.allowedResponseExtensions_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureAllowedResponseExtensionsIsMutable();
          allowedResponseExtensions_.addAll(other.allowedResponseExtensions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.aliyun.openservices.ons.shaded.com.google.api.ContextRule parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.ContextRule) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object selector_ = "";
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The selector.
     */
    public java.lang.String getSelector() {
      java.lang.Object ref = selector_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The bytes for selector.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getSelectorBytes() {
      java.lang.Object ref = selector_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selector_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      selector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelector() {

      selector_ = getDefaultInstance().getSelector();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The bytes for selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelectorBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      selector_ = value;
      onChanged();
      return this;
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList requested_ =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureRequestedIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        requested_ = new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList(requested_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @return A list containing the requested.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getRequestedList() {
      return requested_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @return The count of requested.
     */
    public int getRequestedCount() {
      return requested_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The requested at the given index.
     */
    public java.lang.String getRequested(int index) {
      return requested_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requested at the given index.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getRequestedBytes(int index) {
      return requested_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The requested to set.
     * @return This builder for chaining.
     */
    public Builder setRequested(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestedIsMutable();
      requested_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @param value The requested to add.
     * @return This builder for chaining.
     */
    public Builder addRequested(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestedIsMutable();
      requested_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @param values The requested to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequested(java.lang.Iterable<java.lang.String> values) {
      ensureRequestedIsMutable();
      com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requested_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequested() {
      requested_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of requested contexts.
     * </pre>
     *
     * <code>repeated string requested = 2;</code>
     *
     * @param value The bytes of the requested to add.
     * @return This builder for chaining.
     */
    public Builder addRequestedBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequestedIsMutable();
      requested_.add(value);
      onChanged();
      return this;
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList provided_ =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureProvidedIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        provided_ = new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList(provided_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @return A list containing the provided.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getProvidedList() {
      return provided_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @return The count of provided.
     */
    public int getProvidedCount() {
      return provided_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The provided at the given index.
     */
    public java.lang.String getProvided(int index) {
      return provided_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the provided at the given index.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getProvidedBytes(int index) {
      return provided_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The provided to set.
     * @return This builder for chaining.
     */
    public Builder setProvided(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProvidedIsMutable();
      provided_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @param value The provided to add.
     * @return This builder for chaining.
     */
    public Builder addProvided(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProvidedIsMutable();
      provided_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @param values The provided to add.
     * @return This builder for chaining.
     */
    public Builder addAllProvided(java.lang.Iterable<java.lang.String> values) {
      ensureProvidedIsMutable();
      com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, provided_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvided() {
      provided_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names of provided contexts.
     * </pre>
     *
     * <code>repeated string provided = 3;</code>
     *
     * @param value The bytes of the provided to add.
     * @return This builder for chaining.
     */
    public Builder addProvidedBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureProvidedIsMutable();
      provided_.add(value);
      onChanged();
      return this;
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList allowedRequestExtensions_ =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureAllowedRequestExtensionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        allowedRequestExtensions_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList(allowedRequestExtensions_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @return A list containing the allowedRequestExtensions.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getAllowedRequestExtensionsList() {
      return allowedRequestExtensions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @return The count of allowedRequestExtensions.
     */
    public int getAllowedRequestExtensionsCount() {
      return allowedRequestExtensions_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedRequestExtensions at the given index.
     */
    public java.lang.String getAllowedRequestExtensions(int index) {
      return allowedRequestExtensions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedRequestExtensions at the given index.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getAllowedRequestExtensionsBytes(int index) {
      return allowedRequestExtensions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedRequestExtensions to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedRequestExtensions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedRequestExtensionsIsMutable();
      allowedRequestExtensions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @param value The allowedRequestExtensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedRequestExtensions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedRequestExtensionsIsMutable();
      allowedRequestExtensions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @param values The allowedRequestExtensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedRequestExtensions(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedRequestExtensionsIsMutable();
      com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedRequestExtensions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedRequestExtensions() {
      allowedRequestExtensions_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from client to backend.
     * </pre>
     *
     * <code>repeated string allowed_request_extensions = 4;</code>
     *
     * @param value The bytes of the allowedRequestExtensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedRequestExtensionsBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedRequestExtensionsIsMutable();
      allowedRequestExtensions_.add(value);
      onChanged();
      return this;
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringList allowedResponseExtensions_ =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureAllowedResponseExtensionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        allowedResponseExtensions_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList(allowedResponseExtensions_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @return A list containing the allowedResponseExtensions.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ProtocolStringList getAllowedResponseExtensionsList() {
      return allowedResponseExtensions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @return The count of allowedResponseExtensions.
     */
    public int getAllowedResponseExtensionsCount() {
      return allowedResponseExtensions_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedResponseExtensions at the given index.
     */
    public java.lang.String getAllowedResponseExtensions(int index) {
      return allowedResponseExtensions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedResponseExtensions at the given index.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getAllowedResponseExtensionsBytes(int index) {
      return allowedResponseExtensions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedResponseExtensions to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedResponseExtensions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedResponseExtensionsIsMutable();
      allowedResponseExtensions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @param value The allowedResponseExtensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedResponseExtensions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedResponseExtensionsIsMutable();
      allowedResponseExtensions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @param values The allowedResponseExtensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedResponseExtensions(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedResponseExtensionsIsMutable();
      com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedResponseExtensions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedResponseExtensions() {
      allowedResponseExtensions_ = com.aliyun.openservices.ons.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of full type names or extension IDs of extensions allowed in grpc
     * side channel from backend to client.
     * </pre>
     *
     * <code>repeated string allowed_response_extensions = 5;</code>
     *
     * @param value The bytes of the allowedResponseExtensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedResponseExtensionsBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedResponseExtensionsIsMutable();
      allowedResponseExtensions_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.ContextRule)
  }

  // @@protoc_insertion_point(class_scope:google.api.ContextRule)
  private static final com.aliyun.openservices.ons.shaded.com.google.api.ContextRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.ContextRule();
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.ContextRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<ContextRule> PARSER =
      new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<ContextRule>() {
        @java.lang.Override
        public ContextRule parsePartialFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new ContextRule(input, extensionRegistry);
        }
      };

  public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<ContextRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<ContextRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.ContextRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
