/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/distribution.proto

package com.aliyun.openservices.ons.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * `Distribution` contains summary statistics for a population of values. It
 * optionally contains a histogram representing the distribution of those values
 * across a set of buckets.
 * The summary statistics are the count, mean, sum of the squared deviation from
 * the mean, the minimum, and the maximum of the set of population of values.
 * The histogram is based on a sequence of buckets and gives a count of values
 * that fall into each bucket. The boundaries of the buckets are given either
 * explicitly or by formulas for buckets of fixed or exponentially increasing
 * widths.
 * Although it is not forbidden, it is generally a bad idea to include
 * non-finite values (infinities or NaNs) in the population of values, as this
 * will render the `mean` and `sum_of_squared_deviation` fields meaningless.
 * </pre>
 *
 * Protobuf type {@code google.api.Distribution}
 */
public final class Distribution extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Distribution)
    DistributionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Distribution.newBuilder() to construct.
  private Distribution(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Distribution() {
    bucketCounts_ = emptyLongList();
    exemplars_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Distribution();
  }

  @java.lang.Override
  public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Distribution(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              count_ = input.readInt64();
              break;
            }
          case 17:
            {
              mean_ = input.readDouble();
              break;
            }
          case 25:
            {
              sumOfSquaredDeviation_ = input.readDouble();
              break;
            }
          case 34:
            {
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder subBuilder = null;
              if (range_ != null) {
                subBuilder = range_.toBuilder();
              }
              range_ =
                  input.readMessage(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(range_);
                range_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder subBuilder = null;
              if (bucketOptions_ != null) {
                subBuilder = bucketOptions_.toBuilder();
              }
              bucketOptions_ =
                  input.readMessage(
                      com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(bucketOptions_);
                bucketOptions_ = subBuilder.buildPartial();
              }

              break;
            }
          case 56:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                bucketCounts_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              bucketCounts_.addLong(input.readInt64());
              break;
            }
          case 58:
            {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                bucketCounts_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                bucketCounts_.addLong(input.readInt64());
              }
              input.popLimit(limit);
              break;
            }
          case 82:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                exemplars_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar>();
                mutable_bitField0_ |= 0x00000002;
              }
              exemplars_.add(
                  input.readMessage(
                      com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        bucketCounts_.makeImmutable(); // C
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        exemplars_ = java.util.Collections.unmodifiableList(exemplars_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
  }

  @java.lang.Override
  protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
        .internal_static_google_api_Distribution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.class, com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Builder.class);
  }

  public interface RangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.Range)
      com.aliyun.openservices.ons.shaded.com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The minimum of the population values.
     * </pre>
     *
     * <code>double min = 1;</code>
     *
     * @return The min.
     */
    double getMin();

    /**
     *
     *
     * <pre>
     * The maximum of the population values.
     * </pre>
     *
     * <code>double max = 2;</code>
     *
     * @return The max.
     */
    double getMax();
  }
  /**
   *
   *
   * <pre>
   * The range of the population values.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.Range}
   */
  public static final class Range extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.Range)
      RangeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Range.newBuilder() to construct.
    private Range(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Range() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Range();
    }

    @java.lang.Override
    public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Range(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                min_ = input.readDouble();
                break;
              }
            case 17:
              {
                max_ = input.readDouble();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
          .internal_static_google_api_Distribution_Range_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
          .internal_static_google_api_Distribution_Range_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.class,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder.class);
    }

    public static final int MIN_FIELD_NUMBER = 1;
    private double min_;
    /**
     *
     *
     * <pre>
     * The minimum of the population values.
     * </pre>
     *
     * <code>double min = 1;</code>
     *
     * @return The min.
     */
    @java.lang.Override
    public double getMin() {
      return min_;
    }

    public static final int MAX_FIELD_NUMBER = 2;
    private double max_;
    /**
     *
     *
     * <pre>
     * The maximum of the population values.
     * </pre>
     *
     * <code>double max = 2;</code>
     *
     * @return The max.
     */
    @java.lang.Override
    public double getMax() {
      return max_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(min_) != 0) {
        output.writeDouble(1, min_);
      }
      if (java.lang.Double.doubleToRawLongBits(max_) != 0) {
        output.writeDouble(2, max_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(min_) != 0) {
        size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(1, min_);
      }
      if (java.lang.Double.doubleToRawLongBits(max_) != 0) {
        size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(2, max_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range)) {
        return super.equals(obj);
      }
      com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range other = (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range) obj;

      if (java.lang.Double.doubleToLongBits(getMin())
          != java.lang.Double.doubleToLongBits(other.getMin())) return false;
      if (java.lang.Double.doubleToLongBits(getMax())
          != java.lang.Double.doubleToLongBits(other.getMax())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIN_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMin()));
      hash = (37 * hash) + MAX_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMax()));
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(java.nio.ByteBuffer data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(
        java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(byte[] data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(
        byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(
        java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseDelimitedFrom(
        java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The range of the population values.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.Range}
     */
    public static final class Builder
        extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.Range)
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.RangeOrBuilder {
      public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_Range_descriptor;
      }

      @java.lang.Override
      protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_Range_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.class,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder.class);
      }

      // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        min_ = 0D;

        max_ = 0D;

        return this;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_Range_descriptor;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range getDefaultInstanceForType() {
        return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.getDefaultInstance();
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range build() {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range buildPartial() {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range result = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range(this);
        result.min_ = min_;
        result.max_ = max_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
        if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range) {
          return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range other) {
        if (other == com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.getDefaultInstance()) return this;
        if (other.getMin() != 0D) {
          setMin(other.getMin());
        }
        if (other.getMax() != 0D) {
          setMax(other.getMax());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private double min_;
      /**
       *
       *
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       *
       * @return The min.
       */
      @java.lang.Override
      public double getMin() {
        return min_;
      }
      /**
       *
       *
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       *
       * @param value The min to set.
       * @return This builder for chaining.
       */
      public Builder setMin(double value) {

        min_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMin() {

        min_ = 0D;
        onChanged();
        return this;
      }

      private double max_;
      /**
       *
       *
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       *
       * @return The max.
       */
      @java.lang.Override
      public double getMax() {
        return max_;
      }
      /**
       *
       *
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       *
       * @param value The max to set.
       * @return This builder for chaining.
       */
      public Builder setMax(double value) {

        max_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMax() {

        max_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.Distribution.Range)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.Range)
    private static final com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range();
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Range> PARSER =
        new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<Range>() {
          @java.lang.Override
          public Range parsePartialFrom(
              com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
            return new Range(input, extensionRegistry);
          }
        };

    public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Range> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Range> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BucketOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions)
      com.aliyun.openservices.ons.shaded.com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     *
     * @return Whether the linearBuckets field is set.
     */
    boolean hasLinearBuckets();
    /**
     *
     *
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     *
     * @return The linearBuckets.
     */
    com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear getLinearBuckets();
    /**
     *
     *
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.LinearOrBuilder getLinearBucketsOrBuilder();

    /**
     *
     *
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     *
     * @return Whether the exponentialBuckets field is set.
     */
    boolean hasExponentialBuckets();
    /**
     *
     *
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     *
     * @return The exponentialBuckets.
     */
    com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential getExponentialBuckets();
    /**
     *
     *
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExponentialOrBuilder getExponentialBucketsOrBuilder();

    /**
     *
     *
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     *
     * @return Whether the explicitBuckets field is set.
     */
    boolean hasExplicitBuckets();
    /**
     *
     *
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     *
     * @return The explicitBuckets.
     */
    com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit getExplicitBuckets();
    /**
     *
     *
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExplicitOrBuilder getExplicitBucketsOrBuilder();

    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.OptionsCase getOptionsCase();
  }
  /**
   *
   *
   * <pre>
   * `BucketOptions` describes the bucket boundaries used to create a histogram
   * for the distribution. The buckets can be in a linear sequence, an
   * exponential sequence, or each bucket can be specified explicitly.
   * `BucketOptions` does not include the number of values in each bucket.
   * A bucket has an inclusive lower bound and exclusive upper bound for the
   * values that are counted for that bucket. The upper bound of a bucket must
   * be strictly greater than the lower bound. The sequence of N buckets for a
   * distribution consists of an underflow bucket (number 0), zero or more
   * finite buckets (number 1 through N - 2) and an overflow bucket (number N -
   * 1). The buckets are contiguous: the lower bound of bucket i (i &gt; 0) is the
   * same as the upper bound of bucket i - 1. The buckets span the whole range
   * of finite values: lower bound of the underflow bucket is -infinity and the
   * upper bound of the overflow bucket is +infinity. The finite buckets are
   * so-called because both bounds are finite.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.BucketOptions}
   */
  public static final class BucketOptions extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions)
      BucketOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BucketOptions.newBuilder() to construct.
    private BucketOptions(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BucketOptions() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BucketOptions();
    }

    @java.lang.Override
    public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private BucketOptions(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder subBuilder = null;
                if (optionsCase_ == 1) {
                  subBuilder =
                      ((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_).toBuilder();
                }
                options_ =
                    input.readMessage(
                        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_);
                  options_ = subBuilder.buildPartial();
                }
                optionsCase_ = 1;
                break;
              }
            case 18:
              {
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder subBuilder = null;
                if (optionsCase_ == 2) {
                  subBuilder =
                      ((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_)
                          .toBuilder();
                }
                options_ =
                    input.readMessage(
                        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_);
                  options_ = subBuilder.buildPartial();
                }
                optionsCase_ = 2;
                break;
              }
            case 26:
              {
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder subBuilder = null;
                if (optionsCase_ == 3) {
                  subBuilder =
                      ((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_).toBuilder();
                }
                options_ =
                    input.readMessage(
                        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_);
                  options_ = subBuilder.buildPartial();
                }
                optionsCase_ = 3;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
          .internal_static_google_api_Distribution_BucketOptions_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
          .internal_static_google_api_Distribution_BucketOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.class,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder.class);
    }

    public interface LinearOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Linear)
        com.aliyun.openservices.ons.shaded.com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       *
       * @return The numFiniteBuckets.
       */
      int getNumFiniteBuckets();

      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double width = 2;</code>
       *
       * @return The width.
       */
      double getWidth();

      /**
       *
       *
       * <pre>
       * Lower bound of the first bucket.
       * </pre>
       *
       * <code>double offset = 3;</code>
       *
       * @return The offset.
       */
      double getOffset();
    }
    /**
     *
     *
     * <pre>
     * Specifies a linear sequence of buckets that all have the same width
     * (except overflow and underflow). Each bucket represents a constant
     * absolute uncertainty on the specific value in the bucket.
     * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
     * following boundaries:
     *    Upper bound (0 &lt;= i &lt; N-1):     offset + (width * i).
     *    Lower bound (1 &lt;= i &lt; N):       offset + (width * (i - 1)).
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Linear}
     */
    public static final class Linear extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Linear)
        LinearOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Linear.newBuilder() to construct.
      private Linear(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Linear() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Linear();
      }

      @java.lang.Override
      public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Linear(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  numFiniteBuckets_ = input.readInt32();
                  break;
                }
              case 17:
                {
                  width_ = input.readDouble();
                  break;
                }
              case 25:
                {
                  offset_ = input.readDouble();
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
      }

      @java.lang.Override
      protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_Linear_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.class,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder.class);
      }

      public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
      private int numFiniteBuckets_;
      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       *
       * @return The numFiniteBuckets.
       */
      @java.lang.Override
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }

      public static final int WIDTH_FIELD_NUMBER = 2;
      private double width_;
      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double width = 2;</code>
       *
       * @return The width.
       */
      @java.lang.Override
      public double getWidth() {
        return width_;
      }

      public static final int OFFSET_FIELD_NUMBER = 3;
      private double offset_;
      /**
       *
       *
       * <pre>
       * Lower bound of the first bucket.
       * </pre>
       *
       * <code>double offset = 3;</code>
       *
       * @return The offset.
       */
      @java.lang.Override
      public double getOffset() {
        return offset_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (numFiniteBuckets_ != 0) {
          output.writeInt32(1, numFiniteBuckets_);
        }
        if (java.lang.Double.doubleToRawLongBits(width_) != 0) {
          output.writeDouble(2, width_);
        }
        if (java.lang.Double.doubleToRawLongBits(offset_) != 0) {
          output.writeDouble(3, offset_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (numFiniteBuckets_ != 0) {
          size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeInt32Size(1, numFiniteBuckets_);
        }
        if (java.lang.Double.doubleToRawLongBits(width_) != 0) {
          size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(2, width_);
        }
        if (java.lang.Double.doubleToRawLongBits(offset_) != 0) {
          size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(3, offset_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear)) {
          return super.equals(obj);
        }
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear other =
            (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) obj;

        if (getNumFiniteBuckets() != other.getNumFiniteBuckets()) return false;
        if (java.lang.Double.doubleToLongBits(getWidth())
            != java.lang.Double.doubleToLongBits(other.getWidth())) return false;
        if (java.lang.Double.doubleToLongBits(getOffset())
            != java.lang.Double.doubleToLongBits(other.getOffset())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getNumFiniteBuckets();
        hash = (37 * hash) + WIDTH_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getWidth()));
        hash = (37 * hash) + OFFSET_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getOffset()));
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          java.nio.ByteBuffer data) throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(byte[] data)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseDelimitedFrom(
          java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies a linear sequence of buckets that all have the same width
       * (except overflow and underflow). Each bucket represents a constant
       * absolute uncertainty on the specific value in the bucket.
       * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
       * following boundaries:
       *    Upper bound (0 &lt;= i &lt; N-1):     offset + (width * i).
       *    Lower bound (1 &lt;= i &lt; N):       offset + (width * (i - 1)).
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Linear}
       */
      public static final class Builder
          extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Linear)
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.LinearOrBuilder {
        public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
        }

        @java.lang.Override
        protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Linear_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.class,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder.class);
        }

        // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          numFiniteBuckets_ = 0;

          width_ = 0D;

          offset_ = 0D;

          return this;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear getDefaultInstanceForType() {
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear build() {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear buildPartial() {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear result =
              new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear(this);
          result.numFiniteBuckets_ = numFiniteBuckets_;
          result.width_ = width_;
          result.offset_ = offset_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
          if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) {
            return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear other) {
          if (other == com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance())
            return this;
          if (other.getNumFiniteBuckets() != 0) {
            setNumFiniteBuckets(other.getNumFiniteBuckets());
          }
          if (other.getWidth() != 0D) {
            setWidth(other.getWidth());
          }
          if (other.getOffset() != 0D) {
            setOffset(other.getOffset());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int numFiniteBuckets_;
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         *
         * @return The numFiniteBuckets.
         */
        @java.lang.Override
        public int getNumFiniteBuckets() {
          return numFiniteBuckets_;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         *
         * @param value The numFiniteBuckets to set.
         * @return This builder for chaining.
         */
        public Builder setNumFiniteBuckets(int value) {

          numFiniteBuckets_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNumFiniteBuckets() {

          numFiniteBuckets_ = 0;
          onChanged();
          return this;
        }

        private double width_;
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         *
         * @return The width.
         */
        @java.lang.Override
        public double getWidth() {
          return width_;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         *
         * @param value The width to set.
         * @return This builder for chaining.
         */
        public Builder setWidth(double value) {

          width_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWidth() {

          width_ = 0D;
          onChanged();
          return this;
        }

        private double offset_;
        /**
         *
         *
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         *
         * @return The offset.
         */
        @java.lang.Override
        public double getOffset() {
          return offset_;
        }
        /**
         *
         *
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         *
         * @param value The offset to set.
         * @return This builder for chaining.
         */
        public Builder setOffset(double value) {

          offset_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOffset() {

          offset_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Linear)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Linear)
      private static final com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear();
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Linear> PARSER =
          new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<Linear>() {
            @java.lang.Override
            public Linear parsePartialFrom(
                com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
                com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
              return new Linear(input, extensionRegistry);
            }
          };

      public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Linear> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Linear> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ExponentialOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Exponential)
        com.aliyun.openservices.ons.shaded.com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       *
       * @return The numFiniteBuckets.
       */
      int getNumFiniteBuckets();

      /**
       *
       *
       * <pre>
       * Must be greater than 1.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       *
       * @return The growthFactor.
       */
      double getGrowthFactor();

      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       *
       * @return The scale.
       */
      double getScale();
    }
    /**
     *
     *
     * <pre>
     * Specifies an exponential sequence of buckets that have a width that is
     * proportional to the value of the lower bound. Each bucket represents a
     * constant relative uncertainty on a specific value in the bucket.
     * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
     * following boundaries:
     *    Upper bound (0 &lt;= i &lt; N-1):     scale * (growth_factor ^ i).
     *    Lower bound (1 &lt;= i &lt; N):       scale * (growth_factor ^ (i - 1)).
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Exponential}
     */
    public static final class Exponential extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Exponential)
        ExponentialOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Exponential.newBuilder() to construct.
      private Exponential(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Exponential() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Exponential();
      }

      @java.lang.Override
      public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Exponential(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  numFiniteBuckets_ = input.readInt32();
                  break;
                }
              case 17:
                {
                  growthFactor_ = input.readDouble();
                  break;
                }
              case 25:
                {
                  scale_ = input.readDouble();
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
      }

      @java.lang.Override
      protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_Exponential_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.class,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder.class);
      }

      public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
      private int numFiniteBuckets_;
      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       *
       * @return The numFiniteBuckets.
       */
      @java.lang.Override
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }

      public static final int GROWTH_FACTOR_FIELD_NUMBER = 2;
      private double growthFactor_;
      /**
       *
       *
       * <pre>
       * Must be greater than 1.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       *
       * @return The growthFactor.
       */
      @java.lang.Override
      public double getGrowthFactor() {
        return growthFactor_;
      }

      public static final int SCALE_FIELD_NUMBER = 3;
      private double scale_;
      /**
       *
       *
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       *
       * @return The scale.
       */
      @java.lang.Override
      public double getScale() {
        return scale_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (numFiniteBuckets_ != 0) {
          output.writeInt32(1, numFiniteBuckets_);
        }
        if (java.lang.Double.doubleToRawLongBits(growthFactor_) != 0) {
          output.writeDouble(2, growthFactor_);
        }
        if (java.lang.Double.doubleToRawLongBits(scale_) != 0) {
          output.writeDouble(3, scale_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (numFiniteBuckets_ != 0) {
          size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeInt32Size(1, numFiniteBuckets_);
        }
        if (java.lang.Double.doubleToRawLongBits(growthFactor_) != 0) {
          size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(2, growthFactor_);
        }
        if (java.lang.Double.doubleToRawLongBits(scale_) != 0) {
          size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(3, scale_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential)) {
          return super.equals(obj);
        }
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential other =
            (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) obj;

        if (getNumFiniteBuckets() != other.getNumFiniteBuckets()) return false;
        if (java.lang.Double.doubleToLongBits(getGrowthFactor())
            != java.lang.Double.doubleToLongBits(other.getGrowthFactor())) return false;
        if (java.lang.Double.doubleToLongBits(getScale())
            != java.lang.Double.doubleToLongBits(other.getScale())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getNumFiniteBuckets();
        hash = (37 * hash) + GROWTH_FACTOR_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getGrowthFactor()));
        hash = (37 * hash) + SCALE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getScale()));
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          java.nio.ByteBuffer data) throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(byte[] data)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseDelimitedFrom(
          java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies an exponential sequence of buckets that have a width that is
       * proportional to the value of the lower bound. Each bucket represents a
       * constant relative uncertainty on a specific value in the bucket.
       * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
       * following boundaries:
       *    Upper bound (0 &lt;= i &lt; N-1):     scale * (growth_factor ^ i).
       *    Lower bound (1 &lt;= i &lt; N):       scale * (growth_factor ^ (i - 1)).
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Exponential}
       */
      public static final class Builder
          extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Exponential)
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExponentialOrBuilder {
        public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
        }

        @java.lang.Override
        protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Exponential_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.class,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder.class);
        }

        // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          numFiniteBuckets_ = 0;

          growthFactor_ = 0D;

          scale_ = 0D;

          return this;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential getDefaultInstanceForType() {
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential build() {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential buildPartial() {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential result =
              new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential(this);
          result.numFiniteBuckets_ = numFiniteBuckets_;
          result.growthFactor_ = growthFactor_;
          result.scale_ = scale_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
          if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) {
            return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential other) {
          if (other == com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance())
            return this;
          if (other.getNumFiniteBuckets() != 0) {
            setNumFiniteBuckets(other.getNumFiniteBuckets());
          }
          if (other.getGrowthFactor() != 0D) {
            setGrowthFactor(other.getGrowthFactor());
          }
          if (other.getScale() != 0D) {
            setScale(other.getScale());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int numFiniteBuckets_;
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         *
         * @return The numFiniteBuckets.
         */
        @java.lang.Override
        public int getNumFiniteBuckets() {
          return numFiniteBuckets_;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         *
         * @param value The numFiniteBuckets to set.
         * @return This builder for chaining.
         */
        public Builder setNumFiniteBuckets(int value) {

          numFiniteBuckets_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNumFiniteBuckets() {

          numFiniteBuckets_ = 0;
          onChanged();
          return this;
        }

        private double growthFactor_;
        /**
         *
         *
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         *
         * @return The growthFactor.
         */
        @java.lang.Override
        public double getGrowthFactor() {
          return growthFactor_;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         *
         * @param value The growthFactor to set.
         * @return This builder for chaining.
         */
        public Builder setGrowthFactor(double value) {

          growthFactor_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearGrowthFactor() {

          growthFactor_ = 0D;
          onChanged();
          return this;
        }

        private double scale_;
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         *
         * @return The scale.
         */
        @java.lang.Override
        public double getScale() {
          return scale_;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         *
         * @param value The scale to set.
         * @return This builder for chaining.
         */
        public Builder setScale(double value) {

          scale_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearScale() {

          scale_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Exponential)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Exponential)
      private static final com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential();
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Exponential> PARSER =
          new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<Exponential>() {
            @java.lang.Override
            public Exponential parsePartialFrom(
                com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
                com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
              return new Exponential(input, extensionRegistry);
            }
          };

      public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Exponential> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Exponential> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ExplicitOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Explicit)
        com.aliyun.openservices.ons.shaded.com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       *
       * @return A list containing the bounds.
       */
      java.util.List<java.lang.Double> getBoundsList();
      /**
       *
       *
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       *
       * @return The count of bounds.
       */
      int getBoundsCount();
      /**
       *
       *
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The bounds at the given index.
       */
      double getBounds(int index);
    }
    /**
     *
     *
     * <pre>
     * Specifies a set of buckets with arbitrary widths.
     * There are `size(bounds) + 1` (= N) buckets. Bucket `i` has the following
     * boundaries:
     *    Upper bound (0 &lt;= i &lt; N-1):     bounds[i]
     *    Lower bound (1 &lt;= i &lt; N);       bounds[i - 1]
     * The `bounds` field must contain at least one element. If `bounds` has
     * only one element, then there are no finite buckets, and that single
     * element is the common boundary of the overflow and underflow buckets.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Explicit}
     */
    public static final class Explicit extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Explicit)
        ExplicitOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Explicit.newBuilder() to construct.
      private Explicit(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Explicit() {
        bounds_ = emptyDoubleList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Explicit();
      }

      @java.lang.Override
      public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Explicit(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    bounds_ = newDoubleList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  bounds_.addDouble(input.readDouble());
                  break;
                }
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                    bounds_ = newDoubleList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  while (input.getBytesUntilLimit() > 0) {
                    bounds_.addDouble(input.readDouble());
                  }
                  input.popLimit(limit);
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            bounds_.makeImmutable(); // C
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
      }

      @java.lang.Override
      protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_Explicit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.class,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder.class);
      }

      public static final int BOUNDS_FIELD_NUMBER = 1;
      private com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.DoubleList bounds_;
      /**
       *
       *
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       *
       * @return A list containing the bounds.
       */
      @java.lang.Override
      public java.util.List<java.lang.Double> getBoundsList() {
        return bounds_;
      }
      /**
       *
       *
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       *
       * @return The count of bounds.
       */
      public int getBoundsCount() {
        return bounds_.size();
      }
      /**
       *
       *
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The bounds at the given index.
       */
      public double getBounds(int index) {
        return bounds_.getDouble(index);
      }

      private int boundsMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (getBoundsList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(boundsMemoizedSerializedSize);
        }
        for (int i = 0; i < bounds_.size(); i++) {
          output.writeDoubleNoTag(bounds_.getDouble(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          dataSize = 8 * getBoundsList().size();
          size += dataSize;
          if (!getBoundsList().isEmpty()) {
            size += 1;
            size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          boundsMemoizedSerializedSize = dataSize;
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit)) {
          return super.equals(obj);
        }
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit other =
            (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) obj;

        if (!getBoundsList().equals(other.getBoundsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getBoundsCount() > 0) {
          hash = (37 * hash) + BOUNDS_FIELD_NUMBER;
          hash = (53 * hash) + getBoundsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          java.nio.ByteBuffer data) throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(byte[] data)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseDelimitedFrom(
          java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies a set of buckets with arbitrary widths.
       * There are `size(bounds) + 1` (= N) buckets. Bucket `i` has the following
       * boundaries:
       *    Upper bound (0 &lt;= i &lt; N-1):     bounds[i]
       *    Lower bound (1 &lt;= i &lt; N);       bounds[i - 1]
       * The `bounds` field must contain at least one element. If `bounds` has
       * only one element, then there are no finite buckets, and that single
       * element is the common boundary of the overflow and underflow buckets.
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Explicit}
       */
      public static final class Builder
          extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Explicit)
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExplicitOrBuilder {
        public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
        }

        @java.lang.Override
        protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Explicit_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.class,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder.class);
        }

        // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bounds_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
              .internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit getDefaultInstanceForType() {
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit build() {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit buildPartial() {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit result =
              new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit(this);
          int from_bitField0_ = bitField0_;
          if (((bitField0_ & 0x00000001) != 0)) {
            bounds_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.bounds_ = bounds_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
          if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) {
            return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit other) {
          if (other == com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance())
            return this;
          if (!other.bounds_.isEmpty()) {
            if (bounds_.isEmpty()) {
              bounds_ = other.bounds_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureBoundsIsMutable();
              bounds_.addAll(other.bounds_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.DoubleList bounds_ = emptyDoubleList();

        private void ensureBoundsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            bounds_ = mutableCopy(bounds_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         *
         * @return A list containing the bounds.
         */
        public java.util.List<java.lang.Double> getBoundsList() {
          return ((bitField0_ & 0x00000001) != 0)
              ? java.util.Collections.unmodifiableList(bounds_)
              : bounds_;
        }
        /**
         *
         *
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         *
         * @return The count of bounds.
         */
        public int getBoundsCount() {
          return bounds_.size();
        }
        /**
         *
         *
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The bounds at the given index.
         */
        public double getBounds(int index) {
          return bounds_.getDouble(index);
        }
        /**
         *
         *
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The bounds to set.
         * @return This builder for chaining.
         */
        public Builder setBounds(int index, double value) {
          ensureBoundsIsMutable();
          bounds_.setDouble(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         *
         * @param value The bounds to add.
         * @return This builder for chaining.
         */
        public Builder addBounds(double value) {
          ensureBoundsIsMutable();
          bounds_.addDouble(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         *
         * @param values The bounds to add.
         * @return This builder for chaining.
         */
        public Builder addAllBounds(java.lang.Iterable<? extends java.lang.Double> values) {
          ensureBoundsIsMutable();
          com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bounds_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBounds() {
          bounds_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Explicit)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Explicit)
      private static final com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit();
      }

      public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Explicit> PARSER =
          new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<Explicit>() {
            @java.lang.Override
            public Explicit parsePartialFrom(
                com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
                com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
              return new Explicit(input, extensionRegistry);
            }
          };

      public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Explicit> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Explicit> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int optionsCase_ = 0;
    private java.lang.Object options_;

    public enum OptionsCase
        implements
            com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.EnumLite,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      LINEAR_BUCKETS(1),
      EXPONENTIAL_BUCKETS(2),
      EXPLICIT_BUCKETS(3),
      OPTIONS_NOT_SET(0);
      private final int value;

      private OptionsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OptionsCase valueOf(int value) {
        return forNumber(value);
      }

      public static OptionsCase forNumber(int value) {
        switch (value) {
          case 1:
            return LINEAR_BUCKETS;
          case 2:
            return EXPONENTIAL_BUCKETS;
          case 3:
            return EXPLICIT_BUCKETS;
          case 0:
            return OPTIONS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OptionsCase getOptionsCase() {
      return OptionsCase.forNumber(optionsCase_);
    }

    public static final int LINEAR_BUCKETS_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     *
     * @return Whether the linearBuckets field is set.
     */
    @java.lang.Override
    public boolean hasLinearBuckets() {
      return optionsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     *
     * @return The linearBuckets.
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear getLinearBuckets() {
      if (optionsCase_ == 1) {
        return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_;
      }
      return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.LinearOrBuilder getLinearBucketsOrBuilder() {
      if (optionsCase_ == 1) {
        return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_;
      }
      return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
    }

    public static final int EXPONENTIAL_BUCKETS_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     *
     * @return Whether the exponentialBuckets field is set.
     */
    @java.lang.Override
    public boolean hasExponentialBuckets() {
      return optionsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     *
     * @return The exponentialBuckets.
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential getExponentialBuckets() {
      if (optionsCase_ == 2) {
        return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_;
      }
      return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExponentialOrBuilder
        getExponentialBucketsOrBuilder() {
      if (optionsCase_ == 2) {
        return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_;
      }
      return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
    }

    public static final int EXPLICIT_BUCKETS_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     *
     * @return Whether the explicitBuckets field is set.
     */
    @java.lang.Override
    public boolean hasExplicitBuckets() {
      return optionsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     *
     * @return The explicitBuckets.
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit getExplicitBuckets() {
      if (optionsCase_ == 3) {
        return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_;
      }
      return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExplicitOrBuilder
        getExplicitBucketsOrBuilder() {
      if (optionsCase_ == 3) {
        return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_;
      }
      return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (optionsCase_ == 1) {
        output.writeMessage(1, (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_);
      }
      if (optionsCase_ == 2) {
        output.writeMessage(2, (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_);
      }
      if (optionsCase_ == 3) {
        output.writeMessage(3, (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (optionsCase_ == 1) {
        size +=
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_);
      }
      if (optionsCase_ == 2) {
        size +=
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_);
      }
      if (optionsCase_ == 3) {
        size +=
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions)) {
        return super.equals(obj);
      }
      com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions other =
          (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions) obj;

      if (!getOptionsCase().equals(other.getOptionsCase())) return false;
      switch (optionsCase_) {
        case 1:
          if (!getLinearBuckets().equals(other.getLinearBuckets())) return false;
          break;
        case 2:
          if (!getExponentialBuckets().equals(other.getExponentialBuckets())) return false;
          break;
        case 3:
          if (!getExplicitBuckets().equals(other.getExplicitBuckets())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (optionsCase_) {
        case 1:
          hash = (37 * hash) + LINEAR_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getLinearBuckets().hashCode();
          break;
        case 2:
          hash = (37 * hash) + EXPONENTIAL_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getExponentialBuckets().hashCode();
          break;
        case 3:
          hash = (37 * hash) + EXPLICIT_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getExplicitBuckets().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(java.nio.ByteBuffer data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(
        java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(byte[] data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(
        byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(
        java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseDelimitedFrom(
        java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * `BucketOptions` describes the bucket boundaries used to create a histogram
     * for the distribution. The buckets can be in a linear sequence, an
     * exponential sequence, or each bucket can be specified explicitly.
     * `BucketOptions` does not include the number of values in each bucket.
     * A bucket has an inclusive lower bound and exclusive upper bound for the
     * values that are counted for that bucket. The upper bound of a bucket must
     * be strictly greater than the lower bound. The sequence of N buckets for a
     * distribution consists of an underflow bucket (number 0), zero or more
     * finite buckets (number 1 through N - 2) and an overflow bucket (number N -
     * 1). The buckets are contiguous: the lower bound of bucket i (i &gt; 0) is the
     * same as the upper bound of bucket i - 1. The buckets span the whole range
     * of finite values: lower bound of the underflow bucket is -infinity and the
     * upper bound of the overflow bucket is +infinity. The finite buckets are
     * so-called because both bounds are finite.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions}
     */
    public static final class Builder
        extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions)
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptionsOrBuilder {
      public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_descriptor;
      }

      @java.lang.Override
      protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.class,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder.class);
      }

      // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        optionsCase_ = 0;
        options_ = null;
        return this;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_BucketOptions_descriptor;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions getDefaultInstanceForType() {
        return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions build() {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions buildPartial() {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions result =
            new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions(this);
        if (optionsCase_ == 1) {
          if (linearBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = linearBucketsBuilder_.build();
          }
        }
        if (optionsCase_ == 2) {
          if (exponentialBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = exponentialBucketsBuilder_.build();
          }
        }
        if (optionsCase_ == 3) {
          if (explicitBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = explicitBucketsBuilder_.build();
          }
        }
        result.optionsCase_ = optionsCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
        if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions) {
          return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions other) {
        if (other == com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.getDefaultInstance()) return this;
        switch (other.getOptionsCase()) {
          case LINEAR_BUCKETS:
            {
              mergeLinearBuckets(other.getLinearBuckets());
              break;
            }
          case EXPONENTIAL_BUCKETS:
            {
              mergeExponentialBuckets(other.getExponentialBuckets());
              break;
            }
          case EXPLICIT_BUCKETS:
            {
              mergeExplicitBuckets(other.getExplicitBuckets());
              break;
            }
          case OPTIONS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int optionsCase_ = 0;
      private java.lang.Object options_;

      public OptionsCase getOptionsCase() {
        return OptionsCase.forNumber(optionsCase_);
      }

      public Builder clearOptions() {
        optionsCase_ = 0;
        options_ = null;
        onChanged();
        return this;
      }

      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.LinearOrBuilder>
          linearBucketsBuilder_;
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       *
       * @return Whether the linearBuckets field is set.
       */
      @java.lang.Override
      public boolean hasLinearBuckets() {
        return optionsCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       *
       * @return The linearBuckets.
       */
      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear getLinearBuckets() {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1) {
            return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_;
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        } else {
          if (optionsCase_ == 1) {
            return linearBucketsBuilder_.getMessage();
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder setLinearBuckets(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear value) {
        if (linearBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          linearBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder setLinearBuckets(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder builderForValue) {
        if (linearBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          linearBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder mergeLinearBuckets(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear value) {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1
              && options_
                  != com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance()) {
            options_ =
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.newBuilder(
                        (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 1) {
            linearBucketsBuilder_.mergeFrom(value);
          } else {
            linearBucketsBuilder_.setMessage(value);
          }
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder clearLinearBuckets() {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 1) {
            optionsCase_ = 0;
            options_ = null;
          }
          linearBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder getLinearBucketsBuilder() {
        return getLinearBucketsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.LinearOrBuilder getLinearBucketsOrBuilder() {
        if ((optionsCase_ == 1) && (linearBucketsBuilder_ != null)) {
          return linearBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 1) {
            return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_;
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.LinearOrBuilder>
          getLinearBucketsFieldBuilder() {
        if (linearBucketsBuilder_ == null) {
          if (!(optionsCase_ == 1)) {
            options_ = com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
          }
          linearBucketsBuilder_ =
              new com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear.Builder,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.LinearOrBuilder>(
                  (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Linear) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 1;
        onChanged();
        ;
        return linearBucketsBuilder_;
      }

      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExponentialOrBuilder>
          exponentialBucketsBuilder_;
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       *
       * @return Whether the exponentialBuckets field is set.
       */
      @java.lang.Override
      public boolean hasExponentialBuckets() {
        return optionsCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       *
       * @return The exponentialBuckets.
       */
      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential getExponentialBuckets() {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2) {
            return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_;
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        } else {
          if (optionsCase_ == 2) {
            return exponentialBucketsBuilder_.getMessage();
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder setExponentialBuckets(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential value) {
        if (exponentialBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          exponentialBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder setExponentialBuckets(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder builderForValue) {
        if (exponentialBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          exponentialBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder mergeExponentialBuckets(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential value) {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2
              && options_
                  != com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance()) {
            options_ =
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.newBuilder(
                        (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 2) {
            exponentialBucketsBuilder_.mergeFrom(value);
          } else {
            exponentialBucketsBuilder_.setMessage(value);
          }
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder clearExponentialBuckets() {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 2) {
            optionsCase_ = 0;
            options_ = null;
          }
          exponentialBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder
          getExponentialBucketsBuilder() {
        return getExponentialBucketsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExponentialOrBuilder
          getExponentialBucketsOrBuilder() {
        if ((optionsCase_ == 2) && (exponentialBucketsBuilder_ != null)) {
          return exponentialBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 2) {
            return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_;
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExponentialOrBuilder>
          getExponentialBucketsFieldBuilder() {
        if (exponentialBucketsBuilder_ == null) {
          if (!(optionsCase_ == 2)) {
            options_ = com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
          }
          exponentialBucketsBuilder_ =
              new com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential.Builder,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExponentialOrBuilder>(
                  (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Exponential) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 2;
        onChanged();
        ;
        return exponentialBucketsBuilder_;
      }

      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExplicitOrBuilder>
          explicitBucketsBuilder_;
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       *
       * @return Whether the explicitBuckets field is set.
       */
      @java.lang.Override
      public boolean hasExplicitBuckets() {
        return optionsCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       *
       * @return The explicitBuckets.
       */
      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit getExplicitBuckets() {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3) {
            return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_;
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        } else {
          if (optionsCase_ == 3) {
            return explicitBucketsBuilder_.getMessage();
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder setExplicitBuckets(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit value) {
        if (explicitBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          explicitBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder setExplicitBuckets(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder builderForValue) {
        if (explicitBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          explicitBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder mergeExplicitBuckets(
          com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit value) {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3
              && options_
                  != com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance()) {
            options_ =
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.newBuilder(
                        (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 3) {
            explicitBucketsBuilder_.mergeFrom(value);
          } else {
            explicitBucketsBuilder_.setMessage(value);
          }
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder clearExplicitBuckets() {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 3) {
            optionsCase_ = 0;
            options_ = null;
          }
          explicitBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder
          getExplicitBucketsBuilder() {
        return getExplicitBucketsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExplicitOrBuilder
          getExplicitBucketsOrBuilder() {
        if ((optionsCase_ == 3) && (explicitBucketsBuilder_ != null)) {
          return explicitBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 3) {
            return (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_;
          }
          return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExplicitOrBuilder>
          getExplicitBucketsFieldBuilder() {
        if (explicitBucketsBuilder_ == null) {
          if (!(optionsCase_ == 3)) {
            options_ = com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
          }
          explicitBucketsBuilder_ =
              new com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit.Builder,
                  com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.ExplicitOrBuilder>(
                  (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Explicit) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 3;
        onChanged();
        ;
        return explicitBucketsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions)
    private static final com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions();
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<BucketOptions> PARSER =
        new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<BucketOptions>() {
          @java.lang.Override
          public BucketOptions parsePartialFrom(
              com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
            return new BucketOptions(input, extensionRegistry);
          }
        };

    public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<BucketOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<BucketOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExemplarOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.Exemplar)
      com.aliyun.openservices.ons.shaded.com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Value of the exemplar point. This value determines to which bucket the
     * exemplar belongs.
     * </pre>
     *
     * <code>double value = 1;</code>
     *
     * @return The value.
     */
    double getValue();

    /**
     *
     *
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     *
     * @return Whether the timestamp field is set.
     */
    boolean hasTimestamp();
    /**
     *
     *
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     *
     * @return The timestamp.
     */
    com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp getTimestamp();
    /**
     *
     *
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    com.aliyun.openservices.ons.shaded.com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    java.util.List<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any> getAttachmentsList();
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    com.aliyun.openservices.ons.shaded.com.google.protobuf.Any getAttachments(int index);
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    int getAttachmentsCount();
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder> getAttachmentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder getAttachmentsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Exemplars are example points that may be used to annotate aggregated
   * distribution values. They are metadata that gives information about a
   * particular value added to a Distribution bucket, such as a trace ID that
   * was active when a value was added. They may contain further information,
   * such as a example values and timestamps, origin, etc.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.Exemplar}
   */
  public static final class Exemplar extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.Exemplar)
      ExemplarOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Exemplar.newBuilder() to construct.
    private Exemplar(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Exemplar() {
      attachments_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Exemplar();
    }

    @java.lang.Override
    public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Exemplar(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                value_ = input.readDouble();
                break;
              }
            case 18:
              {
                com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (timestamp_ != null) {
                  subBuilder = timestamp_.toBuilder();
                }
                timestamp_ =
                    input.readMessage(com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(timestamp_);
                  timestamp_ = subBuilder.buildPartial();
                }

                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  attachments_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any>();
                  mutable_bitField0_ |= 0x00000001;
                }
                attachments_.add(
                    input.readMessage(com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.parser(), extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          attachments_ = java.util.Collections.unmodifiableList(attachments_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
          .internal_static_google_api_Distribution_Exemplar_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
          .internal_static_google_api_Distribution_Exemplar_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.class,
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private double value_;
    /**
     *
     *
     * <pre>
     * Value of the exemplar point. This value determines to which bucket the
     * exemplar belongs.
     * </pre>
     *
     * <code>double value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public double getValue() {
      return value_;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 2;
    private com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp timestamp_;
    /**
     *
     *
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     *
     * @return Whether the timestamp field is set.
     */
    @java.lang.Override
    public boolean hasTimestamp() {
      return timestamp_ != null;
    }
    /**
     *
     *
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     *
     * @return The timestamp.
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp getTimestamp() {
      return timestamp_ == null ? com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
    }
    /**
     *
     *
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
      return getTimestamp();
    }

    public static final int ATTACHMENTS_FIELD_NUMBER = 3;
    private java.util.List<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any> attachments_;
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    @java.lang.Override
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any> getAttachmentsList() {
      return attachments_;
    }
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder>
        getAttachmentsOrBuilderList() {
      return attachments_;
    }
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    @java.lang.Override
    public int getAttachmentsCount() {
      return attachments_.size();
    }
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Any getAttachments(int index) {
      return attachments_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder getAttachmentsOrBuilder(int index) {
      return attachments_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        output.writeDouble(1, value_);
      }
      if (timestamp_ != null) {
        output.writeMessage(2, getTimestamp());
      }
      for (int i = 0; i < attachments_.size(); i++) {
        output.writeMessage(3, attachments_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(1, value_);
      }
      if (timestamp_ != null) {
        size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimestamp());
      }
      for (int i = 0; i < attachments_.size(); i++) {
        size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(3, attachments_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar)) {
        return super.equals(obj);
      }
      com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar other = (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar) obj;

      if (java.lang.Double.doubleToLongBits(getValue())
          != java.lang.Double.doubleToLongBits(other.getValue())) return false;
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (!getTimestamp().equals(other.getTimestamp())) return false;
      }
      if (!getAttachmentsList().equals(other.getAttachmentsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getValue()));
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getTimestamp().hashCode();
      }
      if (getAttachmentsCount() > 0) {
        hash = (37 * hash) + ATTACHMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getAttachmentsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(java.nio.ByteBuffer data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(
        java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(byte[] data)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(
        byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(
        java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseDelimitedFrom(
        java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parseFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Exemplars are example points that may be used to annotate aggregated
     * distribution values. They are metadata that gives information about a
     * particular value added to a Distribution bucket, such as a trace ID that
     * was active when a value was added. They may contain further information,
     * such as a example values and timestamps, origin, etc.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.Exemplar}
     */
    public static final class Builder
        extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.Exemplar)
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder {
      public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_Exemplar_descriptor;
      }

      @java.lang.Override
      protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_Exemplar_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.class,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder.class);
      }

      // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAttachmentsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        value_ = 0D;

        if (timestampBuilder_ == null) {
          timestamp_ = null;
        } else {
          timestamp_ = null;
          timestampBuilder_ = null;
        }
        if (attachmentsBuilder_ == null) {
          attachments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          attachmentsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
            .internal_static_google_api_Distribution_Exemplar_descriptor;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar getDefaultInstanceForType() {
        return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.getDefaultInstance();
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar build() {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar buildPartial() {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar result =
            new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar(this);
        int from_bitField0_ = bitField0_;
        result.value_ = value_;
        if (timestampBuilder_ == null) {
          result.timestamp_ = timestamp_;
        } else {
          result.timestamp_ = timestampBuilder_.build();
        }
        if (attachmentsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            attachments_ = java.util.Collections.unmodifiableList(attachments_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.attachments_ = attachments_;
        } else {
          result.attachments_ = attachmentsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
        if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar) {
          return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar other) {
        if (other == com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.getDefaultInstance()) return this;
        if (other.getValue() != 0D) {
          setValue(other.getValue());
        }
        if (other.hasTimestamp()) {
          mergeTimestamp(other.getTimestamp());
        }
        if (attachmentsBuilder_ == null) {
          if (!other.attachments_.isEmpty()) {
            if (attachments_.isEmpty()) {
              attachments_ = other.attachments_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureAttachmentsIsMutable();
              attachments_.addAll(other.attachments_);
            }
            onChanged();
          }
        } else {
          if (!other.attachments_.isEmpty()) {
            if (attachmentsBuilder_.isEmpty()) {
              attachmentsBuilder_.dispose();
              attachmentsBuilder_ = null;
              attachments_ = other.attachments_;
              bitField0_ = (bitField0_ & ~0x00000001);
              attachmentsBuilder_ =
                  com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAttachmentsFieldBuilder()
                      : null;
            } else {
              attachmentsBuilder_.addAllMessages(other.attachments_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private double value_;
      /**
       *
       *
       * <pre>
       * Value of the exemplar point. This value determines to which bucket the
       * exemplar belongs.
       * </pre>
       *
       * <code>double value = 1;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public double getValue() {
        return value_;
      }
      /**
       *
       *
       * <pre>
       * Value of the exemplar point. This value determines to which bucket the
       * exemplar belongs.
       * </pre>
       *
       * <code>double value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(double value) {

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Value of the exemplar point. This value determines to which bucket the
       * exemplar belongs.
       * </pre>
       *
       * <code>double value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = 0D;
        onChanged();
        return this;
      }

      private com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp timestamp_;
      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.Builder,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.TimestampOrBuilder>
          timestampBuilder_;
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       *
       * @return Whether the timestamp field is set.
       */
      public boolean hasTimestamp() {
        return timestampBuilder_ != null || timestamp_ != null;
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       *
       * @return The timestamp.
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp getTimestamp() {
        if (timestampBuilder_ == null) {
          return timestamp_ == null
              ? com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.getDefaultInstance()
              : timestamp_;
        } else {
          return timestampBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder setTimestamp(com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestamp_ = value;
          onChanged();
        } else {
          timestampBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder setTimestamp(com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.Builder builderForValue) {
        if (timestampBuilder_ == null) {
          timestamp_ = builderForValue.build();
          onChanged();
        } else {
          timestampBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder mergeTimestamp(com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (timestamp_ != null) {
            timestamp_ =
                com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.newBuilder(timestamp_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestamp_ = value;
          }
          onChanged();
        } else {
          timestampBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder clearTimestamp() {
        if (timestampBuilder_ == null) {
          timestamp_ = null;
          onChanged();
        } else {
          timestamp_ = null;
          timestampBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.Builder getTimestampBuilder() {

        onChanged();
        return getTimestampFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
        if (timestampBuilder_ != null) {
          return timestampBuilder_.getMessageOrBuilder();
        } else {
          return timestamp_ == null
              ? com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.getDefaultInstance()
              : timestamp_;
        }
      }
      /**
       *
       *
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.Builder,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.TimestampOrBuilder>
          getTimestampFieldBuilder() {
        if (timestampBuilder_ == null) {
          timestampBuilder_ =
              new com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
                  com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp,
                  com.aliyun.openservices.ons.shaded.com.google.protobuf.Timestamp.Builder,
                  com.aliyun.openservices.ons.shaded.com.google.protobuf.TimestampOrBuilder>(
                  getTimestamp(), getParentForChildren(), isClean());
          timestamp_ = null;
        }
        return timestampBuilder_;
      }

      private java.util.List<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any> attachments_ =
          java.util.Collections.emptyList();

      private void ensureAttachmentsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          attachments_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any>(attachments_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Any,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder>
          attachmentsBuilder_;

      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public java.util.List<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any> getAttachmentsList() {
        if (attachmentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(attachments_);
        } else {
          return attachmentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public int getAttachmentsCount() {
        if (attachmentsBuilder_ == null) {
          return attachments_.size();
        } else {
          return attachmentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Any getAttachments(int index) {
        if (attachmentsBuilder_ == null) {
          return attachments_.get(index);
        } else {
          return attachmentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder setAttachments(int index, com.aliyun.openservices.ons.shaded.com.google.protobuf.Any value) {
        if (attachmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentsIsMutable();
          attachments_.set(index, value);
          onChanged();
        } else {
          attachmentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder setAttachments(int index, com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder builderForValue) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.set(index, builderForValue.build());
          onChanged();
        } else {
          attachmentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(com.aliyun.openservices.ons.shaded.com.google.protobuf.Any value) {
        if (attachmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentsIsMutable();
          attachments_.add(value);
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(int index, com.aliyun.openservices.ons.shaded.com.google.protobuf.Any value) {
        if (attachmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentsIsMutable();
          attachments_.add(index, value);
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder builderForValue) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.add(builderForValue.build());
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(int index, com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder builderForValue) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.add(index, builderForValue.build());
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAllAttachments(
          java.lang.Iterable<? extends com.aliyun.openservices.ons.shaded.com.google.protobuf.Any> values) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attachments_);
          onChanged();
        } else {
          attachmentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder clearAttachments() {
        if (attachmentsBuilder_ == null) {
          attachments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          attachmentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder removeAttachments(int index) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.remove(index);
          onChanged();
        } else {
          attachmentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder getAttachmentsBuilder(int index) {
        return getAttachmentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder getAttachmentsOrBuilder(int index) {
        if (attachmentsBuilder_ == null) {
          return attachments_.get(index);
        } else {
          return attachmentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder>
          getAttachmentsOrBuilderList() {
        if (attachmentsBuilder_ != null) {
          return attachmentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(attachments_);
        }
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder addAttachmentsBuilder() {
        return getAttachmentsFieldBuilder()
            .addBuilder(com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder addAttachmentsBuilder(int index) {
        return getAttachmentsFieldBuilder()
            .addBuilder(index, com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.com.aliyun.openservices.ons.shaded.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.com.aliyun.openservices.ons.shaded.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public java.util.List<com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder> getAttachmentsBuilderList() {
        return getAttachmentsFieldBuilder().getBuilderList();
      }

      private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Any,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder>
          getAttachmentsFieldBuilder() {
        if (attachmentsBuilder_ == null) {
          attachmentsBuilder_ =
              new com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
                  com.aliyun.openservices.ons.shaded.com.google.protobuf.Any,
                  com.aliyun.openservices.ons.shaded.com.google.protobuf.Any.Builder,
                  com.aliyun.openservices.ons.shaded.com.google.protobuf.AnyOrBuilder>(
                  attachments_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          attachments_ = null;
        }
        return attachmentsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.Distribution.Exemplar)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.Exemplar)
    private static final com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar();
    }

    public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Exemplar> PARSER =
        new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<Exemplar>() {
          @java.lang.Override
          public Exemplar parsePartialFrom(
              com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
              com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
            return new Exemplar(input, extensionRegistry);
          }
        };

    public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Exemplar> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Exemplar> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int COUNT_FIELD_NUMBER = 1;
  private long count_;
  /**
   *
   *
   * <pre>
   * The number of values in the population. Must be non-negative. This value
   * must equal the sum of the values in `bucket_counts` if a histogram is
   * provided.
   * </pre>
   *
   * <code>int64 count = 1;</code>
   *
   * @return The count.
   */
  @java.lang.Override
  public long getCount() {
    return count_;
  }

  public static final int MEAN_FIELD_NUMBER = 2;
  private double mean_;
  /**
   *
   *
   * <pre>
   * The arithmetic mean of the values in the population. If `count` is zero
   * then this field must be zero.
   * </pre>
   *
   * <code>double mean = 2;</code>
   *
   * @return The mean.
   */
  @java.lang.Override
  public double getMean() {
    return mean_;
  }

  public static final int SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER = 3;
  private double sumOfSquaredDeviation_;
  /**
   *
   *
   * <pre>
   * The sum of squared deviations from the mean of the values in the
   * population. For values x_i this is:
   *     Sum[i=1..n]((x_i - mean)^2)
   * Knuth, "The Art of Computer Programming", Vol. 2, page 232, 3rd edition
   * describes Welford's method for accumulating this sum in one pass.
   * If `count` is zero then this field must be zero.
   * </pre>
   *
   * <code>double sum_of_squared_deviation = 3;</code>
   *
   * @return The sumOfSquaredDeviation.
   */
  @java.lang.Override
  public double getSumOfSquaredDeviation() {
    return sumOfSquaredDeviation_;
  }

  public static final int RANGE_FIELD_NUMBER = 4;
  private com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range range_;
  /**
   *
   *
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   *
   * @return Whether the range field is set.
   */
  @java.lang.Override
  public boolean hasRange() {
    return range_ != null;
  }
  /**
   *
   *
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   *
   * @return The range.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range getRange() {
    return range_ == null ? com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.getDefaultInstance() : range_;
  }
  /**
   *
   *
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.RangeOrBuilder getRangeOrBuilder() {
    return getRange();
  }

  public static final int BUCKET_OPTIONS_FIELD_NUMBER = 6;
  private com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions bucketOptions_;
  /**
   *
   *
   * <pre>
   * Defines the histogram bucket boundaries. If the distribution does not
   * contain a histogram, then omit this field.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   *
   * @return Whether the bucketOptions field is set.
   */
  @java.lang.Override
  public boolean hasBucketOptions() {
    return bucketOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Defines the histogram bucket boundaries. If the distribution does not
   * contain a histogram, then omit this field.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   *
   * @return The bucketOptions.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions getBucketOptions() {
    return bucketOptions_ == null
        ? com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.getDefaultInstance()
        : bucketOptions_;
  }
  /**
   *
   *
   * <pre>
   * Defines the histogram bucket boundaries. If the distribution does not
   * contain a histogram, then omit this field.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
    return getBucketOptions();
  }

  public static final int BUCKET_COUNTS_FIELD_NUMBER = 7;
  private com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.LongList bucketCounts_;
  /**
   *
   *
   * <pre>
   * The number of values in each bucket of the histogram, as described in
   * `bucket_options`. If the distribution does not have a histogram, then omit
   * this field. If there is a histogram, then the sum of the values in
   * `bucket_counts` must equal the value in the `count` field of the
   * distribution.
   * If present, `bucket_counts` should contain N values, where N is the number
   * of buckets specified in `bucket_options`. If you supply fewer than N
   * values, the remaining values are assumed to be 0.
   * The order of the values in `bucket_counts` follows the bucket numbering
   * schemes described for the three bucket types. The first value must be the
   * count for the underflow bucket (number 0). The next N-2 values are the
   * counts for the finite buckets (number 1 through N-2). The N'th value in
   * `bucket_counts` is the count for the overflow bucket (number N-1).
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   *
   * @return A list containing the bucketCounts.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getBucketCountsList() {
    return bucketCounts_;
  }
  /**
   *
   *
   * <pre>
   * The number of values in each bucket of the histogram, as described in
   * `bucket_options`. If the distribution does not have a histogram, then omit
   * this field. If there is a histogram, then the sum of the values in
   * `bucket_counts` must equal the value in the `count` field of the
   * distribution.
   * If present, `bucket_counts` should contain N values, where N is the number
   * of buckets specified in `bucket_options`. If you supply fewer than N
   * values, the remaining values are assumed to be 0.
   * The order of the values in `bucket_counts` follows the bucket numbering
   * schemes described for the three bucket types. The first value must be the
   * count for the underflow bucket (number 0). The next N-2 values are the
   * counts for the finite buckets (number 1 through N-2). The N'th value in
   * `bucket_counts` is the count for the overflow bucket (number N-1).
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   *
   * @return The count of bucketCounts.
   */
  public int getBucketCountsCount() {
    return bucketCounts_.size();
  }
  /**
   *
   *
   * <pre>
   * The number of values in each bucket of the histogram, as described in
   * `bucket_options`. If the distribution does not have a histogram, then omit
   * this field. If there is a histogram, then the sum of the values in
   * `bucket_counts` must equal the value in the `count` field of the
   * distribution.
   * If present, `bucket_counts` should contain N values, where N is the number
   * of buckets specified in `bucket_options`. If you supply fewer than N
   * values, the remaining values are assumed to be 0.
   * The order of the values in `bucket_counts` follows the bucket numbering
   * schemes described for the three bucket types. The first value must be the
   * count for the underflow bucket (number 0). The next N-2 values are the
   * counts for the finite buckets (number 1 through N-2). The N'th value in
   * `bucket_counts` is the count for the overflow bucket (number N-1).
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The bucketCounts at the given index.
   */
  public long getBucketCounts(int index) {
    return bucketCounts_.getLong(index);
  }

  private int bucketCountsMemoizedSerializedSize = -1;

  public static final int EXEMPLARS_FIELD_NUMBER = 10;
  private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar> exemplars_;
  /**
   *
   *
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar> getExemplarsList() {
    return exemplars_;
  }
  /**
   *
   *
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder>
      getExemplarsOrBuilderList() {
    return exemplars_;
  }
  /**
   *
   *
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  @java.lang.Override
  public int getExemplarsCount() {
    return exemplars_.size();
  }
  /**
   *
   *
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar getExemplars(int index) {
    return exemplars_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder getExemplarsOrBuilder(int index) {
    return exemplars_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (count_ != 0L) {
      output.writeInt64(1, count_);
    }
    if (java.lang.Double.doubleToRawLongBits(mean_) != 0) {
      output.writeDouble(2, mean_);
    }
    if (java.lang.Double.doubleToRawLongBits(sumOfSquaredDeviation_) != 0) {
      output.writeDouble(3, sumOfSquaredDeviation_);
    }
    if (range_ != null) {
      output.writeMessage(4, getRange());
    }
    if (bucketOptions_ != null) {
      output.writeMessage(6, getBucketOptions());
    }
    if (getBucketCountsList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(bucketCountsMemoizedSerializedSize);
    }
    for (int i = 0; i < bucketCounts_.size(); i++) {
      output.writeInt64NoTag(bucketCounts_.getLong(i));
    }
    for (int i = 0; i < exemplars_.size(); i++) {
      output.writeMessage(10, exemplars_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (count_ != 0L) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeInt64Size(1, count_);
    }
    if (java.lang.Double.doubleToRawLongBits(mean_) != 0) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(2, mean_);
    }
    if (java.lang.Double.doubleToRawLongBits(sumOfSquaredDeviation_) != 0) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(3, sumOfSquaredDeviation_);
    }
    if (range_ != null) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRange());
    }
    if (bucketOptions_ != null) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(6, getBucketOptions());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < bucketCounts_.size(); i++) {
        dataSize +=
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(bucketCounts_.getLong(i));
      }
      size += dataSize;
      if (!getBucketCountsList().isEmpty()) {
        size += 1;
        size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      bucketCountsMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < exemplars_.size(); i++) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(10, exemplars_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution)) {
      return super.equals(obj);
    }
    com.aliyun.openservices.ons.shaded.com.google.api.Distribution other = (com.aliyun.openservices.ons.shaded.com.google.api.Distribution) obj;

    if (getCount() != other.getCount()) return false;
    if (java.lang.Double.doubleToLongBits(getMean())
        != java.lang.Double.doubleToLongBits(other.getMean())) return false;
    if (java.lang.Double.doubleToLongBits(getSumOfSquaredDeviation())
        != java.lang.Double.doubleToLongBits(other.getSumOfSquaredDeviation())) return false;
    if (hasRange() != other.hasRange()) return false;
    if (hasRange()) {
      if (!getRange().equals(other.getRange())) return false;
    }
    if (hasBucketOptions() != other.hasBucketOptions()) return false;
    if (hasBucketOptions()) {
      if (!getBucketOptions().equals(other.getBucketOptions())) return false;
    }
    if (!getBucketCountsList().equals(other.getBucketCountsList())) return false;
    if (!getExemplarsList().equals(other.getExemplarsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(getCount());
    hash = (37 * hash) + MEAN_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getMean()));
    hash = (37 * hash) + SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getSumOfSquaredDeviation()));
    if (hasRange()) {
      hash = (37 * hash) + RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getRange().hashCode();
    }
    if (hasBucketOptions()) {
      hash = (37 * hash) + BUCKET_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketOptions().hashCode();
    }
    if (getBucketCountsCount() > 0) {
      hash = (37 * hash) + BUCKET_COUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketCountsList().hashCode();
    }
    if (getExemplarsCount() > 0) {
      hash = (37 * hash) + EXEMPLARS_FIELD_NUMBER;
      hash = (53 * hash) + getExemplarsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(java.nio.ByteBuffer data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(
      java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(byte[] data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(
      byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseDelimitedFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.Distribution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `Distribution` contains summary statistics for a population of values. It
   * optionally contains a histogram representing the distribution of those values
   * across a set of buckets.
   * The summary statistics are the count, mean, sum of the squared deviation from
   * the mean, the minimum, and the maximum of the set of population of values.
   * The histogram is based on a sequence of buckets and gives a count of values
   * that fall into each bucket. The boundaries of the buckets are given either
   * explicitly or by formulas for buckets of fixed or exponentially increasing
   * widths.
   * Although it is not forbidden, it is generally a bad idea to include
   * non-finite values (infinities or NaNs) in the population of values, as this
   * will render the `mean` and `sum_of_squared_deviation` fields meaningless.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution}
   */
  public static final class Builder extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Distribution)
      com.aliyun.openservices.ons.shaded.com.google.api.DistributionOrBuilder {
    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto
          .internal_static_google_api_Distribution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.class, com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Builder.class);
    }

    // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Distribution.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExemplarsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      count_ = 0L;

      mean_ = 0D;

      sumOfSquaredDeviation_ = 0D;

      if (rangeBuilder_ == null) {
        range_ = null;
      } else {
        range_ = null;
        rangeBuilder_ = null;
      }
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }
      bucketCounts_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000001);
      if (exemplarsBuilder_ == null) {
        exemplars_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        exemplarsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution getDefaultInstanceForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.Distribution.getDefaultInstance();
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution build() {
      com.aliyun.openservices.ons.shaded.com.google.api.Distribution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution buildPartial() {
      com.aliyun.openservices.ons.shaded.com.google.api.Distribution result = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution(this);
      int from_bitField0_ = bitField0_;
      result.count_ = count_;
      result.mean_ = mean_;
      result.sumOfSquaredDeviation_ = sumOfSquaredDeviation_;
      if (rangeBuilder_ == null) {
        result.range_ = range_;
      } else {
        result.range_ = rangeBuilder_.build();
      }
      if (bucketOptionsBuilder_ == null) {
        result.bucketOptions_ = bucketOptions_;
      } else {
        result.bucketOptions_ = bucketOptionsBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        bucketCounts_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.bucketCounts_ = bucketCounts_;
      if (exemplarsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          exemplars_ = java.util.Collections.unmodifiableList(exemplars_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.exemplars_ = exemplars_;
      } else {
        result.exemplars_ = exemplarsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
      if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Distribution) {
        return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Distribution) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Distribution other) {
      if (other == com.aliyun.openservices.ons.shaded.com.google.api.Distribution.getDefaultInstance()) return this;
      if (other.getCount() != 0L) {
        setCount(other.getCount());
      }
      if (other.getMean() != 0D) {
        setMean(other.getMean());
      }
      if (other.getSumOfSquaredDeviation() != 0D) {
        setSumOfSquaredDeviation(other.getSumOfSquaredDeviation());
      }
      if (other.hasRange()) {
        mergeRange(other.getRange());
      }
      if (other.hasBucketOptions()) {
        mergeBucketOptions(other.getBucketOptions());
      }
      if (!other.bucketCounts_.isEmpty()) {
        if (bucketCounts_.isEmpty()) {
          bucketCounts_ = other.bucketCounts_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureBucketCountsIsMutable();
          bucketCounts_.addAll(other.bucketCounts_);
        }
        onChanged();
      }
      if (exemplarsBuilder_ == null) {
        if (!other.exemplars_.isEmpty()) {
          if (exemplars_.isEmpty()) {
            exemplars_ = other.exemplars_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExemplarsIsMutable();
            exemplars_.addAll(other.exemplars_);
          }
          onChanged();
        }
      } else {
        if (!other.exemplars_.isEmpty()) {
          if (exemplarsBuilder_.isEmpty()) {
            exemplarsBuilder_.dispose();
            exemplarsBuilder_ = null;
            exemplars_ = other.exemplars_;
            bitField0_ = (bitField0_ & ~0x00000002);
            exemplarsBuilder_ =
                com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExemplarsFieldBuilder()
                    : null;
          } else {
            exemplarsBuilder_.addAllMessages(other.exemplars_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.aliyun.openservices.ons.shaded.com.google.api.Distribution parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.Distribution) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private long count_;
    /**
     *
     *
     * <pre>
     * The number of values in the population. Must be non-negative. This value
     * must equal the sum of the values in `bucket_counts` if a histogram is
     * provided.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public long getCount() {
      return count_;
    }
    /**
     *
     *
     * <pre>
     * The number of values in the population. Must be non-negative. This value
     * must equal the sum of the values in `bucket_counts` if a histogram is
     * provided.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     *
     * @param value The count to set.
     * @return This builder for chaining.
     */
    public Builder setCount(long value) {

      count_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of values in the population. Must be non-negative. This value
     * must equal the sum of the values in `bucket_counts` if a histogram is
     * provided.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCount() {

      count_ = 0L;
      onChanged();
      return this;
    }

    private double mean_;
    /**
     *
     *
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     *
     * @return The mean.
     */
    @java.lang.Override
    public double getMean() {
      return mean_;
    }
    /**
     *
     *
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     *
     * @param value The mean to set.
     * @return This builder for chaining.
     */
    public Builder setMean(double value) {

      mean_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMean() {

      mean_ = 0D;
      onChanged();
      return this;
    }

    private double sumOfSquaredDeviation_;
    /**
     *
     *
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population. For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 232, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     *
     * @return The sumOfSquaredDeviation.
     */
    @java.lang.Override
    public double getSumOfSquaredDeviation() {
      return sumOfSquaredDeviation_;
    }
    /**
     *
     *
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population. For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 232, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     *
     * @param value The sumOfSquaredDeviation to set.
     * @return This builder for chaining.
     */
    public Builder setSumOfSquaredDeviation(double value) {

      sumOfSquaredDeviation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population. For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 232, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSumOfSquaredDeviation() {

      sumOfSquaredDeviation_ = 0D;
      onChanged();
      return this;
    }

    private com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range range_;
    private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.RangeOrBuilder>
        rangeBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     *
     * @return Whether the range field is set.
     */
    public boolean hasRange() {
      return rangeBuilder_ != null || range_ != null;
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     *
     * @return The range.
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range getRange() {
      if (rangeBuilder_ == null) {
        return range_ == null ? com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.getDefaultInstance() : range_;
      } else {
        return rangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder setRange(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range value) {
      if (rangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        range_ = value;
        onChanged();
      } else {
        rangeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder setRange(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder builderForValue) {
      if (rangeBuilder_ == null) {
        range_ = builderForValue.build();
        onChanged();
      } else {
        rangeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder mergeRange(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range value) {
      if (rangeBuilder_ == null) {
        if (range_ != null) {
          range_ =
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.newBuilder(range_).mergeFrom(value).buildPartial();
        } else {
          range_ = value;
        }
        onChanged();
      } else {
        rangeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder clearRange() {
      if (rangeBuilder_ == null) {
        range_ = null;
        onChanged();
      } else {
        range_ = null;
        rangeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder getRangeBuilder() {

      onChanged();
      return getRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.RangeOrBuilder getRangeOrBuilder() {
      if (rangeBuilder_ != null) {
        return rangeBuilder_.getMessageOrBuilder();
      } else {
        return range_ == null ? com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.getDefaultInstance() : range_;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.RangeOrBuilder>
        getRangeFieldBuilder() {
      if (rangeBuilder_ == null) {
        rangeBuilder_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Range.Builder,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.RangeOrBuilder>(
                getRange(), getParentForChildren(), isClean());
        range_ = null;
      }
      return rangeBuilder_;
    }

    private com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions bucketOptions_;
    private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptionsOrBuilder>
        bucketOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     *
     * @return Whether the bucketOptions field is set.
     */
    public boolean hasBucketOptions() {
      return bucketOptionsBuilder_ != null || bucketOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     *
     * @return The bucketOptions.
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions getBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        return bucketOptions_ == null
            ? com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.getDefaultInstance()
            : bucketOptions_;
      } else {
        return bucketOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder setBucketOptions(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOptions_ = value;
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder setBucketOptions(
        com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder builderForValue) {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = builderForValue.build();
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder mergeBucketOptions(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (bucketOptions_ != null) {
          bucketOptions_ =
              com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.newBuilder(bucketOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          bucketOptions_ = value;
        }
        onChanged();
      } else {
        bucketOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder clearBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
        onChanged();
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder getBucketOptionsBuilder() {

      onChanged();
      return getBucketOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
      if (bucketOptionsBuilder_ != null) {
        return bucketOptionsBuilder_.getMessageOrBuilder();
      } else {
        return bucketOptions_ == null
            ? com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.getDefaultInstance()
            : bucketOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    private com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptionsOrBuilder>
        getBucketOptionsFieldBuilder() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptionsBuilder_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.SingleFieldBuilderV3<
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptions.Builder,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.BucketOptionsOrBuilder>(
                getBucketOptions(), getParentForChildren(), isClean());
        bucketOptions_ = null;
      }
      return bucketOptionsBuilder_;
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.Internal.LongList bucketCounts_ = emptyLongList();

    private void ensureBucketCountsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        bucketCounts_ = mutableCopy(bucketCounts_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     *
     * @return A list containing the bucketCounts.
     */
    public java.util.List<java.lang.Long> getBucketCountsList() {
      return ((bitField0_ & 0x00000001) != 0)
          ? java.util.Collections.unmodifiableList(bucketCounts_)
          : bucketCounts_;
    }
    /**
     *
     *
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     *
     * @return The count of bucketCounts.
     */
    public int getBucketCountsCount() {
      return bucketCounts_.size();
    }
    /**
     *
     *
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The bucketCounts at the given index.
     */
    public long getBucketCounts(int index) {
      return bucketCounts_.getLong(index);
    }
    /**
     *
     *
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The bucketCounts to set.
     * @return This builder for chaining.
     */
    public Builder setBucketCounts(int index, long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     *
     * @param value The bucketCounts to add.
     * @return This builder for chaining.
     */
    public Builder addBucketCounts(long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.addLong(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     *
     * @param values The bucketCounts to add.
     * @return This builder for chaining.
     */
    public Builder addAllBucketCounts(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureBucketCountsIsMutable();
      com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bucketCounts_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketCounts() {
      bucketCounts_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar> exemplars_ =
        java.util.Collections.emptyList();

    private void ensureExemplarsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        exemplars_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar>(exemplars_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder>
        exemplarsBuilder_;

    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar> getExemplarsList() {
      if (exemplarsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(exemplars_);
      } else {
        return exemplarsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public int getExemplarsCount() {
      if (exemplarsBuilder_ == null) {
        return exemplars_.size();
      } else {
        return exemplarsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar getExemplars(int index) {
      if (exemplarsBuilder_ == null) {
        return exemplars_.get(index);
      } else {
        return exemplarsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder setExemplars(int index, com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.set(index, value);
        onChanged();
      } else {
        exemplarsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder setExemplars(
        int index, com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.set(index, builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.add(value);
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(int index, com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.add(index, value);
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.add(builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(
        int index, com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.add(index, builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addAllExemplars(
        java.lang.Iterable<? extends com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar> values) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exemplars_);
        onChanged();
      } else {
        exemplarsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder clearExemplars() {
      if (exemplarsBuilder_ == null) {
        exemplars_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        exemplarsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder removeExemplars(int index) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.remove(index);
        onChanged();
      } else {
        exemplarsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder getExemplarsBuilder(int index) {
      return getExemplarsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder getExemplarsOrBuilder(int index) {
      if (exemplarsBuilder_ == null) {
        return exemplars_.get(index);
      } else {
        return exemplarsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder>
        getExemplarsOrBuilderList() {
      if (exemplarsBuilder_ != null) {
        return exemplarsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(exemplars_);
      }
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder addExemplarsBuilder() {
      return getExemplarsFieldBuilder()
          .addBuilder(com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder addExemplarsBuilder(int index) {
      return getExemplarsFieldBuilder()
          .addBuilder(index, com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder> getExemplarsBuilderList() {
      return getExemplarsFieldBuilder().getBuilderList();
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder>
        getExemplarsFieldBuilder() {
      if (exemplarsBuilder_ == null) {
        exemplarsBuilder_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.Exemplar.Builder,
                com.aliyun.openservices.ons.shaded.com.google.api.Distribution.ExemplarOrBuilder>(
                exemplars_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        exemplars_ = null;
      }
      return exemplarsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Distribution)
  }

  // @@protoc_insertion_point(class_scope:google.api.Distribution)
  private static final com.aliyun.openservices.ons.shaded.com.google.api.Distribution DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Distribution();
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Distribution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Distribution> PARSER =
      new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<Distribution>() {
        @java.lang.Override
        public Distribution parsePartialFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new Distribution(input, extensionRegistry);
        }
      };

  public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Distribution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Distribution> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Distribution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
