/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/visibility.proto

package com.aliyun.openservices.ons.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * `Visibility` defines restrictions for the visibility of service
 * elements.  Restrictions are specified using visibility labels
 * (e.g., PREVIEW) that are elsewhere linked to users and projects.
 * Users and projects can have access to more than one visibility label. The
 * effective visibility for multiple labels is the union of each label's
 * elements, plus any unrestricted elements.
 * If an element and its parents have no restrictions, visibility is
 * unconditionally granted.
 * Example:
 *     visibility:
 *       rules:
 *       - selector: google.calendar.Calendar.EnhancedSearch
 *         restriction: PREVIEW
 *       - selector: google.calendar.Calendar.Delegate
 *         restriction: INTERNAL
 * Here, all methods are publicly visible except for the restricted methods
 * EnhancedSearch and Delegate.
 * </pre>
 *
 * Protobuf type {@code google.api.Visibility}
 */
public final class Visibility extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Visibility)
    VisibilityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Visibility.newBuilder() to construct.
  private Visibility(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Visibility() {
    rules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Visibility();
  }

  @java.lang.Override
  public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Visibility(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                rules_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule>();
                mutable_bitField0_ |= 0x00000001;
              }
              rules_.add(
                  input.readMessage(com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        rules_ = java.util.Collections.unmodifiableList(rules_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.aliyun.openservices.ons.shaded.com.google.api.VisibilityProto.internal_static_google_api_Visibility_descriptor;
  }

  @java.lang.Override
  protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.aliyun.openservices.ons.shaded.com.google.api.VisibilityProto.internal_static_google_api_Visibility_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.aliyun.openservices.ons.shaded.com.google.api.Visibility.class, com.aliyun.openservices.ons.shaded.com.google.api.Visibility.Builder.class);
  }

  public static final int RULES_FIELD_NUMBER = 1;
  private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule> rules_;
  /**
   *
   *
   * <pre>
   * A list of visibility rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.VisibilityRule rules = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * A list of visibility rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.VisibilityRule rules = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRuleOrBuilder> getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * A list of visibility rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.VisibilityRule rules = 1;</code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of visibility rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.VisibilityRule rules = 1;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of visibility rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.VisibilityRule rules = 1;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(1, rules_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < rules_.size(); i++) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(1, rules_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.Visibility)) {
      return super.equals(obj);
    }
    com.aliyun.openservices.ons.shaded.com.google.api.Visibility other = (com.aliyun.openservices.ons.shaded.com.google.api.Visibility) obj;

    if (!getRulesList().equals(other.getRulesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(java.nio.ByteBuffer data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(
      java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(byte[] data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(
      byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseDelimitedFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.Visibility prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `Visibility` defines restrictions for the visibility of service
   * elements.  Restrictions are specified using visibility labels
   * (e.g., PREVIEW) that are elsewhere linked to users and projects.
   * Users and projects can have access to more than one visibility label. The
   * effective visibility for multiple labels is the union of each label's
   * elements, plus any unrestricted elements.
   * If an element and its parents have no restrictions, visibility is
   * unconditionally granted.
   * Example:
   *     visibility:
   *       rules:
   *       - selector: google.calendar.Calendar.EnhancedSearch
   *         restriction: PREVIEW
   *       - selector: google.calendar.Calendar.Delegate
   *         restriction: INTERNAL
   * Here, all methods are publicly visible except for the restricted methods
   * EnhancedSearch and Delegate.
   * </pre>
   *
   * Protobuf type {@code google.api.Visibility}
   */
  public static final class Builder extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Visibility)
      com.aliyun.openservices.ons.shaded.com.google.api.VisibilityOrBuilder {
    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.VisibilityProto.internal_static_google_api_Visibility_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.VisibilityProto.internal_static_google_api_Visibility_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.Visibility.class, com.aliyun.openservices.ons.shaded.com.google.api.Visibility.Builder.class);
    }

    // Construct using com.aliyun.openservices.ons.shaded.com.google.api.Visibility.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRulesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.VisibilityProto.internal_static_google_api_Visibility_descriptor;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Visibility getDefaultInstanceForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.Visibility.getDefaultInstance();
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Visibility build() {
      com.aliyun.openservices.ons.shaded.com.google.api.Visibility result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.Visibility buildPartial() {
      com.aliyun.openservices.ons.shaded.com.google.api.Visibility result = new com.aliyun.openservices.ons.shaded.com.google.api.Visibility(this);
      int from_bitField0_ = bitField0_;
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
      if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.Visibility) {
        return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.Visibility) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.Visibility other) {
      if (other == com.aliyun.openservices.ons.shaded.com.google.api.Visibility.getDefaultInstance()) return this;
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000001);
            rulesBuilder_ =
                com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.aliyun.openservices.ons.shaded.com.google.api.Visibility parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.Visibility) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        rules_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule>(rules_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule,
            com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder setRules(int index, com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder setRules(int index, com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder addRules(com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder addRules(int index, com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder addRules(com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder addRules(int index, com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder addAllRules(java.lang.Iterable<? extends com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder().addBuilder(com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of visibility rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.VisibilityRule rules = 1;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder> getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule,
            com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
                com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule,
                com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRule.Builder,
                com.aliyun.openservices.ons.shaded.com.google.api.VisibilityRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Visibility)
  }

  // @@protoc_insertion_point(class_scope:google.api.Visibility)
  private static final com.aliyun.openservices.ons.shaded.com.google.api.Visibility DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.Visibility();
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.Visibility getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Visibility> PARSER =
      new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<Visibility>() {
        @java.lang.Override
        public Visibility parsePartialFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new Visibility(input, extensionRegistry);
        }
      };

  public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Visibility> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<Visibility> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.Visibility getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
