/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics;


import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Consumer;

/** Builder class for {@link DoubleValueObserver}. */
public interface DoubleValueObserverBuilder
    extends AsynchronousInstrumentBuilder<AsynchronousInstrument.DoubleResult> {
  @Override
  DoubleValueObserverBuilder setDescription(String description);

  @Override
  DoubleValueObserverBuilder setUnit(String unit);

  @Override
  DoubleValueObserverBuilder setUpdater(Consumer<AsynchronousInstrument.DoubleResult> updater);

  @Override
  DoubleValueObserver build();
}
