/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleUpDownSumObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.DoubleUpDownSumObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.BiFunction;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentType;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleUpDownSumObserverSdk extends AbstractAsynchronousInstrument
    implements DoubleUpDownSumObserver {

  DoubleUpDownSumObserverSdk(
      InstrumentDescriptor descriptor, AsynchronousInstrumentAccumulator accumulator) {
    super(descriptor, accumulator);
  }

  static final class Builder
      extends AbstractDoubleAsynchronousInstrumentBuilder<DoubleUpDownSumObserverSdk.Builder>
      implements DoubleUpDownSumObserverBuilder {

    Builder(
        String name,
        MeterProviderSharedState meterProviderSharedState,
        MeterSharedState meterSharedState) {
      super(
          name,
          InstrumentType.UP_DOWN_SUM_OBSERVER,
          InstrumentValueType.DOUBLE,
          meterProviderSharedState,
          meterSharedState);
    }

    @Override
    Builder getThis() {
      return this;
    }

    @Override
    public DoubleUpDownSumObserverSdk build() {
      return buildInstrument(
          new BiFunction<InstrumentDescriptor, AsynchronousInstrumentAccumulator, DoubleUpDownSumObserverSdk>() {
            @Override
            public DoubleUpDownSumObserverSdk apply(InstrumentDescriptor instrumentDescriptor,
                AsynchronousInstrumentAccumulator asynchronousInstrumentAccumulator) {
              return new DoubleUpDownSumObserverSdk(instrumentDescriptor, asynchronousInstrumentAccumulator);
            }
          });
    }
  }
}
