/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanId;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceId;
import java.util.Random;

/**
 * {@link IdGenerator} instance that doesn't use {@link java.util.concurrent.ThreadLocalRandom},
 * which is broken on most versions of Android (it uses the same seed everytime it starts up).
 */
class AndroidFriendlyRandomIdGenerator extends IdGenerator {
  public static final AndroidFriendlyRandomIdGenerator INSTANCE = new AndroidFriendlyRandomIdGenerator();

  private static final Random random = new Random();

  private static final long INVALID_ID = 0;

  @Override
  public String generateSpanId() {
    long id;
    do {
      id = random.nextLong();
    } while (id == INVALID_ID);
    return SpanId.fromLong(id);
  }

  @Override
  public String generateTraceId() {
    long idHi;
    long idLo;
    do {
      idHi = random.nextLong();
      idLo = random.nextLong();
    } while (idHi == INVALID_ID && idLo == INVALID_ID);
    return TraceId.fromLongs(idHi, idLo);
  }
}
