/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route;

public enum Permission {
    /**
     * No any permission.
     */
    NONE(0),
    /**
     * Readable.
     */
    READ(1),
    /**
     * Writable.
     */
    WRITE(2),
    /**
     * Both of readable and writable.
     */
    READ_WRITE(3);

    private final int value;

    Permission(int value) {
        this.value = value;
    }

    public boolean isWritable() {
        switch (this) {
            case WRITE:
            case READ_WRITE:
                return true;
            case NONE:
            case READ:
            default:
                return false;
        }
    }

    public boolean isReadable() {
        switch (this) {
            case READ:
            case READ_WRITE:
                return true;
            case NONE:
            case WRITE:
            default:
                return false;
        }
    }

    public int getValue() {
        return this.value;
    }
}
