/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.core;

import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.ShutdownException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.core.DataFetcher;
import com.aliyun.openservices.ots.internal.streamclient.model.ICheckpointTracker;
import com.aliyun.openservices.ots.internal.streamclient.model.IRecordProcessorCheckpointer;
import com.aliyun.openservices.ots.internal.streamclient.model.ShardInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordProcessorCheckpointer
implements IRecordProcessorCheckpointer {
    private static final Logger LOG = LoggerFactory.getLogger(RecordProcessorCheckpointer.class);
    private ShardInfo shardInfo;
    private ICheckpointTracker checkpointTracker;
    private String largestPermittedCheckpointValue;
    private DataFetcher dataFetcher;

    public RecordProcessorCheckpointer(ShardInfo shardInfo, ICheckpointTracker checkpointTracker, DataFetcher dataFetcher) {
        this.shardInfo = shardInfo;
        this.checkpointTracker = checkpointTracker;
        this.dataFetcher = dataFetcher;
    }

    @Override
    public synchronized void checkpoint() throws ShutdownException, StreamClientException, DependencyException {
        this.doCheckpoint(this.largestPermittedCheckpointValue);
    }

    @Override
    public synchronized void checkpoint(String checkpointValue) throws ShutdownException, StreamClientException, DependencyException {
        this.doCheckpoint(checkpointValue);
    }

    @Override
    public String getLargestPermittedCheckpointValue() {
        return this.largestPermittedCheckpointValue;
    }

    public void setLargestPermittedCheckpointValue(String largestPermittedCheckpointValue) {
        this.largestPermittedCheckpointValue = largestPermittedCheckpointValue;
    }

    private void doCheckpoint(String checkpointValue) throws ShutdownException, StreamClientException, DependencyException {
        LOG.debug("DoCheckpoint, ShardId: {}, Checkpoint: {}.", (Object)this.shardInfo.getShardId(), (Object)checkpointValue);
        this.checkpointTracker.setCheckpoint(this.shardInfo.getShardId(), checkpointValue, this.shardInfo.getLeaseIdentifier());
        this.dataFetcher.updateCheckpoint(checkpointValue);
    }
}

