/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.aliyun.openservices.ots.internal.streamclient.lease.ShardLease;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseManager;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class MemoryLeaseManager
implements ILeaseManager<ShardLease> {
    private NavigableMap<String, ShardLease> table = new ConcurrentSkipListMap<String, ShardLease>();

    @Override
    public boolean createLeaseTableIfNotExists(int readCU, int writeCU, int ttl) {
        return true;
    }

    @Override
    public boolean waitUntilTableReady(long maxWaitTimeMillis) {
        return true;
    }

    @Override
    public List<ShardLease> listLeases() {
        ArrayList<ShardLease> shardLeases = new ArrayList<ShardLease>();
        for (String leaseKey : this.table.keySet()) {
            shardLeases.add((ShardLease)((ShardLease)this.table.get(leaseKey)).copy());
        }
        return shardLeases;
    }

    @Override
    public void createLease(ShardLease lease) {
        ShardLease copy = (ShardLease)lease.copy();
        copy.setLeaseIdentifier("");
        copy.setLastCounterIncrementMillis(0L);
        this.table.put(lease.getLeaseKey(), copy);
    }

    @Override
    public ShardLease getLease(String leaseKey) {
        if (this.table.get(leaseKey) == null) {
            return null;
        }
        return (ShardLease)((ShardLease)this.table.get(leaseKey)).copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renewLease(ShardLease lease) {
        NavigableMap<String, ShardLease> navigableMap = this.table;
        synchronized (navigableMap) {
            if (((ShardLease)this.table.get(lease.getLeaseKey())).getLeaseCounter() != lease.getLeaseCounter()) {
                return false;
            }
            lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
            ShardLease newLease = (ShardLease)this.table.get(lease.getLeaseKey());
            newLease.setLeaseCounter(newLease.getLeaseCounter() + 1L);
            this.table.put(newLease.getLeaseKey(), newLease);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean takeLease(ShardLease lease, String owner) {
        NavigableMap<String, ShardLease> navigableMap = this.table;
        synchronized (navigableMap) {
            if (((ShardLease)this.table.get(lease.getLeaseKey())).getLeaseCounter() != lease.getLeaseCounter()) {
                return false;
            }
            lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
            lease.setLeaseOwner(owner);
            lease.setLeaseStealer("");
            ShardLease newLease = (ShardLease)this.table.get(lease.getLeaseKey());
            newLease.setLeaseCounter(newLease.getLeaseCounter() + 1L);
            newLease.setLeaseOwner(owner);
            newLease.setLeaseStealer("");
            this.table.put(newLease.getLeaseKey(), newLease);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stealLease(ShardLease lease, String stealer) {
        NavigableMap<String, ShardLease> navigableMap = this.table;
        synchronized (navigableMap) {
            if (!((ShardLease)this.table.get(lease.getLeaseKey())).getLeaseStealer().isEmpty()) {
                return false;
            }
            if (!((ShardLease)this.table.get(lease.getLeaseKey())).getLeaseOwner().equals(lease.getLeaseOwner())) {
                return false;
            }
            lease.setLeaseStealer(stealer);
            ShardLease newLease = (ShardLease)this.table.get(lease.getLeaseKey());
            newLease.setLeaseStealer(stealer);
            this.table.put(newLease.getLeaseKey(), newLease);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transferLease(ShardLease lease) {
        NavigableMap<String, ShardLease> navigableMap = this.table;
        synchronized (navigableMap) {
            if (((ShardLease)this.table.get(lease.getLeaseKey())).getLeaseCounter() != lease.getLeaseCounter()) {
                return false;
            }
            lease.setLeaseOwner(lease.getLeaseStealer());
            lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
            ShardLease newLease = (ShardLease)this.table.get(lease.getLeaseKey());
            newLease.setLeaseCounter(newLease.getLeaseCounter() + 1L);
            newLease.setLeaseOwner(lease.getLeaseStealer());
            this.table.put(newLease.getLeaseKey(), newLease);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLease(String leaseKey) {
        NavigableMap<String, ShardLease> navigableMap = this.table;
        synchronized (navigableMap) {
            this.table.remove(leaseKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLease(ShardLease lease) {
        NavigableMap<String, ShardLease> navigableMap = this.table;
        synchronized (navigableMap) {
            if (((ShardLease)this.table.get(lease.getLeaseKey())).getLeaseCounter() != lease.getLeaseCounter()) {
                return false;
            }
            lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
            ShardLease newLease = (ShardLease)this.table.get(lease.getLeaseKey());
            newLease.setLeaseCounter(newLease.getLeaseCounter() + 1L);
            newLease.setCheckpoint(lease.getCheckpoint());
            this.table.put(newLease.getLeaseKey(), newLease);
            return true;
        }
    }

    public void clear() {
        this.table.clear();
    }
}

