/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.auth.RequestSignerInterface;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.auth.SignatureMakerFactory;
import com.alicloud.openservices.tablestore.core.auth.SignatureMakerInterface;
import com.alicloud.openservices.tablestore.core.http.RequestMessage;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.io.UnsupportedEncodingException;

public class RequestSigner
implements RequestSignerInterface {
    private ServiceCredentials credentials;
    private byte[] accessKey;
    private byte[] instanceName;

    public RequestSigner(String instanceName, ServiceCredentials credentials) {
        Preconditions.checkNotNull(instanceName);
        Preconditions.checkNotNull(credentials);
        this.credentials = credentials;
        this.accessKey = Bytes.toBytes(credentials.getAccessKeySecret());
        try {
            this.instanceName = instanceName.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Unsupport encoding: iso-8859-1");
        }
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        try {
            SignatureMakerInterface signatureMaker = SignatureMakerFactory.getSignatureMaker(this.credentials);
            signatureMaker.addExtraHeader(request);
            String signature = signatureMaker.getSignature(this.accessKey, request.getActionUri().getAction(), request.getRequest().getMethod(), request.getRequest().getAllHeaders());
            request.addHeader(signatureMaker.getSignatureHeader(), signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("\u65e0\u6cd5\u8ba1\u7b97\u7b7e\u540d\uff1a" + e.getMessage());
        }
    }
}

