/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.TableStoreNoPermissionException;
import com.alicloud.openservices.tablestore.core.http.ResponseHandler;
import com.alicloud.openservices.tablestore.core.http.ResponseMessage;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(responseData);
        if (responseData.isSuccessful()) {
            return;
        }
        Map<String, String> headers = responseData.getLowerCaseHeadersMap();
        int httpStatus = responseData.getStatusCode();
        if (httpStatus == 301) {
            if (!headers.containsKey("location")) {
                throw new ClientException("The required header is missing: location");
            }
            String location = headers.get("location");
            throw new ClientException("The endpoint of service has moved to:" + location);
        }
        InputStream errorStream = null;
        try {
            errorStream = responseData.getContent();
        }
        catch (IOException e) {
            throw new ClientException("Failed to read response from server.", e);
        }
        if (errorStream == null) {
            throw new ClientException("Network error.");
        }
        String requestId = headers.get("x-ots-requestid");
        if (requestId == null) {
            throw new ClientException("TableStore returns a response with status code: " + responseData.getStatusCode() + ".");
        }
        try {
            OtsInternalApi.Error errMsg = OtsInternalApi.Error.parseFrom(errorStream);
            if (errMsg.hasAccessDeniedDetail()) {
                throw new TableStoreNoPermissionException(errMsg.getMessage(), null, errMsg.getCode(), requestId, httpStatus, errMsg.getAccessDeniedDetail());
            }
            throw new TableStoreException(errMsg.getMessage(), null, errMsg.getCode(), requestId, httpStatus);
        }
        catch (IOException e) {
            throw new ClientException("Network error.", e);
        }
    }
}

