/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.utils;

import com.alicloud.openservices.tablestore.model.ColumnValue;

public class ValueUtil {
    public static ColumnValue toColumnValue(Object value) {
        if (value instanceof Long) {
            return ColumnValue.fromLong((Long)value);
        }
        if (value instanceof Integer) {
            return ColumnValue.fromLong(((Integer)value).longValue());
        }
        if (value instanceof Double) {
            return ColumnValue.fromDouble((Double)value);
        }
        if (value instanceof String) {
            return ColumnValue.fromString((String)value);
        }
        if (value instanceof Boolean) {
            return ColumnValue.fromBoolean((Boolean)value);
        }
        if (value instanceof byte[]) {
            return ColumnValue.fromBinary((byte[])value);
        }
        throw new IllegalArgumentException("unsupported type: " + value.getClass());
    }

    public static Object toObject(ColumnValue value) {
        switch (value.getType()) {
            case INTEGER: {
                return value.asLong();
            }
            case STRING: {
                return value.asString();
            }
            case BOOLEAN: {
                return value.asBoolean();
            }
            case DOUBLE: {
                return value.asDouble();
            }
            case BINARY: {
                return value.asBinary();
            }
        }
        throw new RuntimeException("unexpected");
    }
}

