/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import java.util.Random;

public class AlwaysRetryStrategy
implements RetryStrategy {
    private final Random rnd = new Random();
    private int base = 4;
    private int retries = 0;
    private int maxRetryTimes = 3;
    private int maxRetryPauseInMillis = 1000;

    public AlwaysRetryStrategy() {
    }

    public AlwaysRetryStrategy(int maxRetryTimes, int maxRetryPauseInMillis) {
        Preconditions.checkArgument(maxRetryTimes > 0);
        Preconditions.checkArgument(maxRetryPauseInMillis > 1);
        this.maxRetryTimes = maxRetryTimes;
        this.maxRetryPauseInMillis = maxRetryPauseInMillis;
    }

    public AlwaysRetryStrategy(int initialPauseInMillis, int maxRetryTimes, int maxRetryPauseInMillis) {
        this(maxRetryTimes, maxRetryPauseInMillis);
        Preconditions.checkArgument(initialPauseInMillis > 0);
        this.base = initialPauseInMillis;
    }

    @Override
    public AlwaysRetryStrategy clone() {
        return new AlwaysRetryStrategy(this.maxRetryTimes, this.maxRetryPauseInMillis);
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public long nextPause(String action, Exception ex) {
        if (this.retries >= this.maxRetryTimes) {
            return 0L;
        }
        if (this.base <= 0) {
            return 0L;
        }
        int maxPause = 0;
        if (this.base * 2 < this.maxRetryPauseInMillis) {
            this.base *= 2;
            maxPause = this.base;
        } else {
            maxPause = this.maxRetryPauseInMillis;
        }
        int halfPause = maxPause / 2;
        long delay = halfPause + this.rnd.nextInt(maxPause - halfPause);
        ++this.retries;
        return delay;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getMaxRetryPauseInMillis() {
        return this.maxRetryPauseInMillis;
    }

    public void setMaxRetryPauseInMillis(int maxRetryPauseInMillis) {
        this.maxRetryPauseInMillis = maxRetryPauseInMillis;
    }
}

