/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.Constants;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCrc8;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.Row;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class SimpleRowMatrixBlockParser {
    private final ByteBuffer buffer;
    private final int apiVersion;
    private final int dataOffset;
    private final int optionsOffset;
    private final int pkCount;
    private final int attrCount;
    private final int fieldCount;
    private final int footerOffset;
    private final int totalBufferBytes;
    private final boolean hasEntirePrimaryKeys;
    private final int rowCount;
    private final int fieldNameArrayOffset;
    private final int[] fieldDataOffsetArray;
    private String[] fieldNames;
    private int nextRowIndex = 0;
    private int nextRowOffset;

    public SimpleRowMatrixBlockParser(ByteBuffer buffer) {
        buffer.rewind();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer = buffer;
        this.totalBufferBytes = buffer.limit();
        this.apiVersion = buffer.getInt();
        SimpleRowMatrixBlockParser.ensureEqual(this.apiVersion, 810373715, "apiVersion");
        this.dataOffset = buffer.getInt();
        SimpleRowMatrixBlockParser.ensureNonNegative(this.dataOffset, "dataOffset");
        this.optionsOffset = buffer.getInt();
        SimpleRowMatrixBlockParser.ensureNonNegative(this.optionsOffset, "optionsOffset");
        this.pkCount = buffer.getInt();
        SimpleRowMatrixBlockParser.ensureNonNegative(this.pkCount, "pkCount");
        this.attrCount = buffer.getInt();
        SimpleRowMatrixBlockParser.ensureNonNegative(this.attrCount, "attrCount");
        this.fieldCount = this.pkCount + this.attrCount;
        this.fieldNameArrayOffset = buffer.position();
        buffer.position(this.optionsOffset);
        byte tagEntirePrimaryKeys = buffer.get();
        SimpleRowMatrixBlockParser.ensureEqual(tagEntirePrimaryKeys, (byte)10, "tagEntirePrimaryKeys");
        byte hasEntirePrimaryKeys = buffer.get();
        if (hasEntirePrimaryKeys != 0 && hasEntirePrimaryKeys != 1) {
            throw new ClientException("Invalid hasEntirePrimaryKeys value:" + hasEntirePrimaryKeys);
        }
        this.hasEntirePrimaryKeys = hasEntirePrimaryKeys == 1;
        byte tagRowCount = buffer.get();
        SimpleRowMatrixBlockParser.ensureEqual(tagRowCount, (byte)3, "tagRowCount");
        this.rowCount = buffer.getInt();
        SimpleRowMatrixBlockParser.ensureNonNegative(this.rowCount, "rowCount");
        buffer.position(this.totalBufferBytes - 2);
        byte tagCheckSum = buffer.get();
        SimpleRowMatrixBlockParser.ensureEqual(tagCheckSum, (byte)1, "tagCheckSum");
        byte crc = buffer.get();
        byte expectCrc = this.calcCheckSum();
        SimpleRowMatrixBlockParser.ensureEqual(crc, expectCrc, "checksum");
        this.fieldDataOffsetArray = new int[this.fieldCount];
        this.footerOffset = this.totalBufferBytes - 2;
        this.nextRowOffset = this.dataOffset;
    }

    private static void ensureEqual(byte actual, byte expect, String fieldName) {
        if (actual != expect) {
            throw new ClientException(fieldName + " mismatch. Actual:" + actual + ". Expect:" + expect);
        }
    }

    private static void ensureEqual(int actual, int expect, String fieldName) {
        if (actual != expect) {
            throw new ClientException(fieldName + " mismatch. Actual:" + actual + ". Expect:" + expect);
        }
    }

    private static void ensureNonNegative(int value, String fieldName) {
        if (value < 0) {
            throw new ClientException(fieldName + " can't be negative. Now:" + value);
        }
    }

    public String[] parseFieldNames() {
        if (this.fieldNames == null) {
            this.fieldNames = new String[this.fieldCount];
            this.buffer.position(this.fieldNameArrayOffset);
            for (int i = 0; i < this.fieldCount; ++i) {
                short nameLength = this.buffer.getShort();
                SimpleRowMatrixBlockParser.ensureNonNegative(nameLength, "nameLength");
                this.fieldNames[i] = this.retrieveString(nameLength);
            }
        }
        return this.fieldNames;
    }

    public int getPkCount() {
        return this.pkCount;
    }

    public int getAttrCount() {
        return this.attrCount;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public boolean hasEntirePrimaryKeys() {
        return this.hasEntirePrimaryKeys;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean hasNext() {
        return this.nextRowOffset < this.footerOffset;
    }

    public int next() {
        if (!this.hasNext()) {
            throw new ClientException("SimpleRowMatrixBlockParser has no next");
        }
        this.buffer.position(this.nextRowOffset);
        byte tagRow = this.buffer.get();
        SimpleRowMatrixBlockParser.ensureEqual(tagRow, (byte)2, "tagRow");
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fieldDataOffsetArray[i] = this.buffer.position();
            byte type = this.buffer.get();
            this.skipColumn(this.toColumnType(type));
        }
        this.nextRowOffset = this.buffer.position();
        return this.nextRowIndex++;
    }

    public int getTotalBytes() {
        return this.totalBufferBytes;
    }

    public int getDataBytes() {
        return this.footerOffset - this.dataOffset;
    }

    public boolean isNull(int fieldIndex) {
        return this.getColumnType(fieldIndex) == null;
    }

    public boolean getBoolean(int fieldIndex) {
        ColumnType type = this.getColumnType(fieldIndex);
        if (type != ColumnType.BOOLEAN) {
            throw new ClientException("ColumnType mismatch. Actual:" + (Object)((Object)type) + ". Expect:" + (Object)((Object)ColumnType.BOOLEAN));
        }
        byte value = this.buffer.get();
        if (value != 0 && value != 1) {
            throw new ClientException("Invalid value for boolean:" + value);
        }
        return value != 0;
    }

    public long getLong(int fieldIndex) {
        ColumnType type = this.getColumnType(fieldIndex);
        if (type != ColumnType.INTEGER) {
            throw new ClientException("ColumnType mismatch. Actual:" + (Object)((Object)type) + ". Expect:" + (Object)((Object)ColumnType.INTEGER));
        }
        return this.buffer.getLong();
    }

    public double getDouble(int fieldIndex) {
        ColumnType type = this.getColumnType(fieldIndex);
        if (type != ColumnType.DOUBLE) {
            throw new ClientException("ColumnType mismatch. Actual:" + (Object)((Object)type) + ". Expect:" + (Object)((Object)ColumnType.DOUBLE));
        }
        return this.buffer.getDouble();
    }

    public String getString(int fieldIndex) {
        ColumnType type = this.getColumnType(fieldIndex);
        if (type != ColumnType.STRING) {
            throw new ClientException("ColumnType mismatch. Actual:" + (Object)((Object)type) + ". Expect:" + (Object)((Object)ColumnType.STRING));
        }
        int length = this.buffer.getInt();
        return this.retrieveString(length);
    }

    public byte[] getBinary(int fieldIndex) {
        ColumnType type = this.getColumnType(fieldIndex);
        if (type != ColumnType.BINARY) {
            throw new ClientException("ColumnType mismatch. Actual:" + (Object)((Object)type) + ". Expect:" + (Object)((Object)ColumnType.BINARY));
        }
        int length = this.buffer.getInt();
        byte[] bs = new byte[length];
        this.buffer.get(bs);
        return bs;
    }

    public Object getObject(int fieldIndex) {
        ColumnType type = this.getColumnType(fieldIndex);
        if (type == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                return this.getString(fieldIndex);
            }
            case BINARY: {
                return this.getBinary(fieldIndex);
            }
            case BOOLEAN: {
                return this.getBoolean(fieldIndex);
            }
            case INTEGER: {
                return this.getLong(fieldIndex);
            }
            case DOUBLE: {
                return this.getDouble(fieldIndex);
            }
        }
        throw new ClientException("Unknown columnType:" + (Object)((Object)type));
    }

    public ColumnType getColumnType(int fieldIndex) {
        this.buffer.position(this.fieldDataOffsetArray[fieldIndex]);
        byte type = this.buffer.get();
        return this.toColumnType(type);
    }

    public Row getRow() {
        ArrayList<PrimaryKeyColumn> pks = new ArrayList<PrimaryKeyColumn>(this.pkCount);
        this.parseFieldNames();
        block12: for (int j = 0; j < this.pkCount; ++j) {
            ColumnType type = this.getColumnType(j);
            switch (type) {
                case INTEGER: {
                    pks.add(new PrimaryKeyColumn(this.fieldNames[j], PrimaryKeyValue.fromLong(this.getLong(j))));
                    continue block12;
                }
                case STRING: {
                    pks.add(new PrimaryKeyColumn(this.fieldNames[j], PrimaryKeyValue.fromString(this.getString(j))));
                    continue block12;
                }
                case BINARY: {
                    pks.add(new PrimaryKeyColumn(this.fieldNames[j], PrimaryKeyValue.fromBinary(this.getBinary(j))));
                    continue block12;
                }
                default: {
                    throw new ClientException("Invalid ColumnType for PrimaryKeyType:" + (Object)((Object)type));
                }
            }
        }
        ArrayList<Column> cols = new ArrayList<Column>(this.attrCount);
        block13: for (int j = this.pkCount; j < this.fieldCount; ++j) {
            ColumnType type = this.getColumnType(j);
            if (type == null) continue;
            switch (type) {
                case INTEGER: {
                    cols.add(new Column(this.fieldNames[j], ColumnValue.fromLong(this.getLong(j))));
                    continue block13;
                }
                case BOOLEAN: {
                    cols.add(new Column(this.fieldNames[j], ColumnValue.fromBoolean(this.getBoolean(j))));
                    continue block13;
                }
                case DOUBLE: {
                    cols.add(new Column(this.fieldNames[j], ColumnValue.fromDouble(this.getDouble(j))));
                    continue block13;
                }
                case STRING: {
                    cols.add(new Column(this.fieldNames[j], ColumnValue.fromString(this.getString(j))));
                    continue block13;
                }
                case BINARY: {
                    cols.add(new Column(this.fieldNames[j], ColumnValue.fromBinary(this.getBinary(j))));
                    continue block13;
                }
                default: {
                    throw new ClientException("Invalid ColumnType:" + (Object)((Object)type));
                }
            }
        }
        return new Row(new PrimaryKey(pks), cols);
    }

    public List<Row> getRows() {
        ArrayList<Row> rows = new ArrayList<Row>(this.rowCount);
        this.nextRowOffset = this.dataOffset;
        for (int i = 0; i < this.rowCount; ++i) {
            this.next();
            rows.add(this.getRow());
        }
        return rows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleRowMatrixBlock{");
        sb.append("apiVersion=").append(this.apiVersion).append(", pkCount=").append(this.pkCount).append(", attrCount=").append(this.attrCount).append(", fieldCount=").append(this.fieldCount).append(", rowCount=").append(this.rowCount).append(", fieldNameArrayOffset=").append(this.fieldNameArrayOffset).append(", dataOffset=").append(this.dataOffset).append(", footerOffset=").append(this.footerOffset).append(", totalBufferBytes=").append(this.totalBufferBytes).append(", hasEntirePrimaryKeys=").append(this.hasEntirePrimaryKeys).append('}');
        return sb.toString();
    }

    private byte calcCheckSum() {
        int current = this.buffer.position();
        this.buffer.position(0);
        byte crc = 0;
        for (int i = 0; i < this.totalBufferBytes - 1; ++i) {
            crc = PlainBufferCrc8.crc8(crc, this.buffer.get());
        }
        this.buffer.position(current);
        return crc;
    }

    private ColumnType toColumnType(byte value) {
        switch (value) {
            case 0: {
                return ColumnType.INTEGER;
            }
            case 1: {
                return ColumnType.DOUBLE;
            }
            case 2: {
                return ColumnType.BOOLEAN;
            }
            case 3: {
                return ColumnType.STRING;
            }
            case 6: {
                return null;
            }
            case 7: {
                return ColumnType.BINARY;
            }
        }
        throw new ClientException("Unsupported data type:" + value);
    }

    private String retrieveString(int length) {
        if (this.buffer.isReadOnly()) {
            byte[] bs = new byte[length];
            this.buffer.get(bs);
            return new String(bs, Constants.UTF8_CHARSET);
        }
        int p = this.buffer.position();
        String x = new String(this.buffer.array(), p, length);
        this.buffer.position(p + length);
        return x;
    }

    private void skipColumn(ColumnType type) {
        int skipLen = 0;
        if (type != null) {
            switch (type) {
                case STRING: 
                case BINARY: {
                    skipLen = this.buffer.getInt();
                    break;
                }
                case BOOLEAN: {
                    skipLen = 1;
                    break;
                }
                case INTEGER: 
                case DOUBLE: {
                    skipLen = 8;
                    break;
                }
                default: {
                    throw new ClientException("Unknown columnType:" + (Object)((Object)type));
                }
            }
        }
        this.buffer.position(this.buffer.position() + skipLen);
    }
}

