/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.model.search.DateTimeUnit;
import com.alicloud.openservices.tablestore.model.search.DateTimeValue;
import com.alicloud.openservices.tablestore.model.search.query.DecayParam;

public class DecayFuncDateParam
extends DecayParam {
    private final DecayParam.ParamType type = DecayParam.ParamType.DATE;
    private Long originLong;
    private String originString;
    private DateTimeValue scale;
    private DateTimeValue offset;

    public DecayFuncDateParam() {
    }

    public DecayFuncDateParam(Long originLong, String originString, DateTimeValue scale, DateTimeValue offset) {
        this.originLong = originLong;
        this.originString = originString;
        this.scale = scale;
        this.offset = offset;
    }

    public Long getOriginLong() {
        return this.originLong;
    }

    public void setOriginLong(Long originLong) {
        this.originLong = originLong;
    }

    public String getOriginString() {
        return this.originString;
    }

    public void setOriginString(String originString) {
        this.originString = originString;
    }

    public DateTimeValue getScale() {
        return this.scale;
    }

    public void setScale(DateTimeValue scale) {
        this.scale = scale;
    }

    public DateTimeValue getOffset() {
        return this.offset;
    }

    public void setOffset(DateTimeValue offset) {
        this.offset = offset;
    }

    @Override
    public DecayParam.ParamType getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final DecayParam.ParamType type = DecayParam.ParamType.DATE;
        private Long originLong;
        private String originString;
        private DateTimeValue scale;
        private DateTimeValue offset;

        private Builder() {
        }

        public Long originLong() {
            return this.originLong;
        }

        public Builder originLong(long originLong) {
            this.originLong = originLong;
            return this;
        }

        public String originString() {
            return this.originString;
        }

        public Builder originString(String originString) {
            this.originString = originString;
            return this;
        }

        public DateTimeValue scale() {
            return this.scale;
        }

        public Builder scale(DateTimeValue scale) {
            this.scale = scale;
            return this;
        }

        public Builder scale(Integer value, DateTimeUnit unit) {
            this.scale = new DateTimeValue(value, unit);
            return this;
        }

        public DateTimeValue offset() {
            return this.offset;
        }

        public Builder offset(DateTimeValue offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer value, DateTimeUnit unit) {
            this.offset = new DateTimeValue(value, unit);
            return this;
        }

        public DecayParam.ParamType type() {
            return this.type;
        }

        public DecayFuncDateParam build() {
            DecayFuncDateParam decayFuncDateParam = new DecayFuncDateParam();
            decayFuncDateParam.setOffset(this.offset);
            decayFuncDateParam.setScale(this.scale);
            decayFuncDateParam.setOriginString(this.originString);
            decayFuncDateParam.setOriginLong(this.originLong);
            return decayFuncDateParam;
        }
    }
}

