/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.model.search.query.DecayParam;
import com.alicloud.openservices.tablestore.model.search.query.MultiValueMode;

public class DecayFunction {
    private String fieldName;
    private DecayParam decayParam;
    private MathFunction mathFunction;
    private Double decay;
    private MultiValueMode multiValueMode;

    public DecayFunction() {
    }

    public DecayFunction(String fieldName, DecayParam decayParam, MathFunction mathFunction, Double decay, MultiValueMode multiValueMode) {
        this.fieldName = fieldName;
        this.decayParam = decayParam;
        this.mathFunction = mathFunction;
        this.decay = decay;
        this.multiValueMode = multiValueMode;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public DecayParam getDecayParam() {
        return this.decayParam;
    }

    public void setDecayParam(DecayParam decayParam) {
        this.decayParam = decayParam;
    }

    public MathFunction getMathFunction() {
        return this.mathFunction;
    }

    public void setMathFunction(MathFunction mathFunction) {
        this.mathFunction = mathFunction;
    }

    public Double getDecay() {
        return this.decay;
    }

    public void setDecay(Double decay) {
        this.decay = decay;
    }

    public MultiValueMode getMultiValueMode() {
        return this.multiValueMode;
    }

    public void setMultiValueMode(MultiValueMode multiValueMode) {
        this.multiValueMode = multiValueMode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum MathFunction {
        UNKNOWN,
        GAUSS,
        EXP,
        LINEAR;

    }

    public static final class Builder {
        private String fieldName;
        private DecayParam decayParam;
        private MathFunction mathFunction;
        private Double decay;
        private MultiValueMode multiValueMode;

        private Builder() {
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public DecayParam decayParam() {
            return this.decayParam;
        }

        public Builder decayParam(DecayParam decayParam) {
            this.decayParam = decayParam;
            return this;
        }

        public MathFunction mathFunction() {
            return this.mathFunction;
        }

        public Builder mathFunction(MathFunction mathFunction) {
            this.mathFunction = mathFunction;
            return this;
        }

        public Double decay() {
            return this.decay;
        }

        public Builder decay(double decay) {
            this.decay = decay;
            return this;
        }

        public MultiValueMode multiValueMode() {
            return this.multiValueMode;
        }

        public Builder multiValueMode(MultiValueMode multiValueMode) {
            this.multiValueMode = multiValueMode;
            return this;
        }

        public DecayFunction build() {
            DecayFunction decayFunction = new DecayFunction();
            decayFunction.setMathFunction(this.mathFunction);
            decayFunction.setDecay(this.decay);
            decayFunction.setDecayParam(this.decayParam);
            decayFunction.setMultiValueMode(this.multiValueMode);
            decayFunction.setFieldName(this.fieldName);
            return decayFunction;
        }
    }
}

