/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.sql;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnType;

public class SQLColumnSchema
implements Jsonizable {
    private String name;
    private ColumnType type;

    public SQLColumnSchema(String name, ColumnType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "SQL col's name should not be null or empty.");
        Preconditions.checkNotNull(type, "The type should not be null.");
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SQLColumnSchema)) {
            return false;
        }
        SQLColumnSchema target = (SQLColumnSchema)o;
        return this.name.equals(target.name) && this.type == target.type;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    public String toString() {
        return this.name + ":" + (Object)((Object)this.type);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append(String.format("{\"Name\": \"%s\", \"Type\": \"%s\"}", this.name, this.type.toString()));
    }
}

