/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;

public class GetRowIterator
implements Iterator<Row> {
    private AsyncClient asyncClient;
    private GetRowRequest request;
    private GetRowResponse response;
    private boolean getNext = false;

    public GetRowIterator(AsyncClient asyncClient, GetRowRequest request) {
        this.asyncClient = asyncClient;
        this.request = request;
        this.fetchData();
    }

    private void fetchData() {
        try {
            this.response = this.asyncClient.getRow(this.request, null).get();
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.getNext) {
            return this.response.getRow() != null;
        }
        return false;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.getNext = true;
        return this.response.getRow();
    }

    @Override
    public void remove() {
        throw new RuntimeException("GetRangeIterator do not support remove().");
    }
}

