/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model.query;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.timestream.internal.Utils;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamMeta;
import com.alicloud.openservices.tablestore.timestream.model.query.MetaFilter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaGetter {
    static Logger logger = LoggerFactory.getLogger(MetaFilter.class);
    private AsyncClient asyncClient;
    private String metaTableName;
    private TimestreamIdentifier identifier;
    private boolean returnAll = false;
    private List<String> attrToGet = null;

    public MetaGetter(AsyncClient asyncClient, String metaTableName, TimestreamIdentifier identifier) {
        this.asyncClient = asyncClient;
        this.metaTableName = metaTableName;
        this.identifier = identifier;
    }

    public MetaGetter selectAttributes(String ... columns) {
        if (this.returnAll) {
            throw new ClientException("returnAll has been set.");
        }
        this.attrToGet = Arrays.asList(columns);
        return this;
    }

    public List<String> getAttributesToSelect() {
        return this.attrToGet;
    }

    public MetaGetter returnAll() {
        if (this.attrToGet != null) {
            throw new ClientException("Attributes to select has been set.");
        }
        this.returnAll = true;
        return this;
    }

    public boolean isReturnAll() {
        return this.returnAll;
    }

    public TimestreamMeta fetch() {
        GetRowResponse response;
        SingleRowQueryCriteria rowQuery = new SingleRowQueryCriteria(this.metaTableName, Utils.convertIdentifierToPK(this.identifier).build());
        rowQuery.setMaxVersions(1);
        GetRowRequest request = new GetRowRequest(rowQuery);
        if (!this.returnAll) {
            if (this.attrToGet != null) {
                rowQuery.addColumnsToGet(this.attrToGet);
                rowQuery.addColumnsToGet("s");
            } else {
                rowQuery.addColumnsToGet("s");
            }
        }
        try {
            response = this.asyncClient.getRow(request, null).get();
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
        if (response.getRow() == null) {
            return null;
        }
        return Utils.deserializeTimestreamMeta(response.getRow());
    }
}

