/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.Group;
import com.alicloud.openservices.tablestore.writer.RowChangeEvent;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.config.BucketConfig;
import com.alicloud.openservices.tablestore.writer.handle.RowEventHandler;
import com.alicloud.openservices.tablestore.writer.handle.WriterHandleStatistics;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bucket {
    private Logger logger = LoggerFactory.getLogger(Bucket.class);
    private final BucketConfig bucketConfig;
    private final Disruptor<RowChangeEvent> disruptor;
    private final RingBuffer<RowChangeEvent> ringBuffer;
    private final RowEventHandler eventHandler;
    private final ExecutorService disruptorExecutor;
    private final WriterConfig writerConfig;
    private final Semaphore semaphore;
    private TableStoreCallback<RowChange, RowWriteResult> resultCallback;

    public Bucket(BucketConfig bucketConfig, AsyncClientInterface ots, WriterConfig writerConfig, TableStoreCallback<RowChange, RowWriteResult> resultCallback, Executor executor, WriterHandleStatistics writerStatistics, Semaphore semaphore) {
        RowChangeEvent.RowChangeEventFactory factory = new RowChangeEvent.RowChangeEventFactory();
        this.bucketConfig = bucketConfig;
        this.writerConfig = writerConfig;
        this.semaphore = semaphore;
        this.resultCallback = resultCallback;
        this.disruptorExecutor = Executors.newFixedThreadPool(1);
        this.disruptor = new Disruptor((EventFactory)factory, this.writerConfig.getBufferSize(), (Executor)this.disruptorExecutor);
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.eventHandler = new RowEventHandler(ots, bucketConfig, writerConfig, this.resultCallback, executor, writerStatistics, this.semaphore);
        this.disruptor.handleEventsWith(new EventHandler[]{this.eventHandler});
        this.disruptor.start();
    }

    public boolean addRowChange(RowChange rowChange, Group group) {
        try {
            long sequence = this.ringBuffer.tryNext();
            RowChangeEvent event = (RowChangeEvent)this.ringBuffer.get(sequence);
            event.setValue(rowChange, group);
            this.ringBuffer.publish(sequence);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public void setResultCallback(TableStoreCallback<RowChange, RowWriteResult> resultCallback) {
        this.eventHandler.setCallback(resultCallback);
    }

    public void addSignal(CountDownLatch latch) {
        while (true) {
            try {
                long sequence = this.ringBuffer.tryNext();
                RowChangeEvent event = (RowChangeEvent)this.ringBuffer.get(sequence);
                event.setValue(latch);
                this.ringBuffer.publish(sequence);
                return;
            }
            catch (InsufficientCapacityException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public synchronized void close() {
        this.disruptor.shutdown();
        this.disruptorExecutor.shutdown();
    }

    public int getId() {
        return this.bucketConfig.getBucketId();
    }

    public RingBuffer<RowChangeEvent> getRingBuffer() {
        return this.ringBuffer;
    }
}

