/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.nio.codecs;

import com.aliyun.ots.thirdparty.org.apache.annotation.NotThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.impl.io.HttpTransportMetricsImpl;
import com.aliyun.ots.thirdparty.org.apache.nio.ContentEncoder;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.SessionOutputBuffer;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import com.aliyun.ots.thirdparty.org.apache.util.Asserts;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

@NotThreadSafe
public abstract class AbstractContentEncoder
implements ContentEncoder {
    protected final WritableByteChannel channel;
    protected final SessionOutputBuffer buffer;
    protected final HttpTransportMetricsImpl metrics;
    protected boolean completed;

    public AbstractContentEncoder(WritableByteChannel channel, SessionOutputBuffer buffer, HttpTransportMetricsImpl metrics) {
        Args.notNull(channel, "Channel");
        Args.notNull(buffer, "Session input buffer");
        Args.notNull(metrics, "Transport metrics");
        this.buffer = buffer;
        this.channel = channel;
        this.metrics = metrics;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void complete() throws IOException {
        this.completed = true;
    }

    protected void assertNotCompleted() {
        Asserts.check(!this.completed, "Encoding process already completed");
    }

    protected int flushToChannel() throws IOException {
        if (!this.buffer.hasData()) {
            return 0;
        }
        int bytesWritten = this.buffer.flush(this.channel);
        if (bytesWritten > 0) {
            this.metrics.incrementBytesTransferred(bytesWritten);
        }
        return bytesWritten;
    }

    protected int writeToChannel(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            return 0;
        }
        int bytesWritten = this.channel.write(src);
        if (bytesWritten > 0) {
            this.metrics.incrementBytesTransferred(bytesWritten);
        }
        return bytesWritten;
    }

    protected int writeToChannel(ByteBuffer src, int limit) throws IOException {
        return this.doWriteChunk(src, limit, true);
    }

    protected int writeToBuffer(ByteBuffer src, int limit) throws IOException {
        return this.doWriteChunk(src, limit, false);
    }

    private int doWriteChunk(ByteBuffer src, int chunk, boolean direct) throws IOException {
        int bytesWritten;
        if (src.remaining() > chunk) {
            int oldLimit = src.limit();
            int newLimit = oldLimit - (src.remaining() - chunk);
            src.limit(newLimit);
            bytesWritten = this.doWriteChunk(src, direct);
            src.limit(oldLimit);
        } else {
            bytesWritten = this.doWriteChunk(src, direct);
        }
        return bytesWritten;
    }

    private int doWriteChunk(ByteBuffer src, boolean direct) throws IOException {
        if (direct) {
            int bytesWritten = this.channel.write(src);
            if (bytesWritten > 0) {
                this.metrics.incrementBytesTransferred(bytesWritten);
            }
            return bytesWritten;
        }
        int chunk = src.remaining();
        this.buffer.write(src);
        return chunk;
    }
}

