/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.nio.pool;

import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.HttpResponse;
import com.aliyun.ots.thirdparty.org.apache.HttpResponseFactory;
import com.aliyun.ots.thirdparty.org.apache.annotation.Immutable;
import com.aliyun.ots.thirdparty.org.apache.config.ConnectionConfig;
import com.aliyun.ots.thirdparty.org.apache.impl.DefaultHttpResponseFactory;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.DefaultNHttpClientConnectionFactory;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.SSLNHttpClientConnectionFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpClientConnection;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpConnectionFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpMessageParserFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpMessageWriterFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.pool.NIOConnFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.IOSession;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.ssl.SSLSetupHandler;
import com.aliyun.ots.thirdparty.org.apache.nio.util.ByteBufferAllocator;
import com.aliyun.ots.thirdparty.org.apache.nio.util.HeapByteBufferAllocator;
import com.aliyun.ots.thirdparty.org.apache.params.HttpParams;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        Args.notNull(plainFactory, "Plain HTTP client connection factory");
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseFactory, allocator, params));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(responseParserFactory, requestWriterFactory, allocator, config), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseParserFactory, requestWriterFactory, allocator, config));
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslcontext, sslHandler, null, null, null, config);
    }

    public BasicNIOConnFactory(ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(config), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

