/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.nio.protocol;

import com.aliyun.ots.thirdparty.org.apache.HttpEntity;
import com.aliyun.ots.thirdparty.org.apache.HttpEntityEnclosingRequest;
import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.annotation.ThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.nio.ContentEncoder;
import com.aliyun.ots.thirdparty.org.apache.nio.IOControl;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.EntityAsyncContentProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.HttpAsyncContentProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.HttpAsyncRequestProducer;
import com.aliyun.ots.thirdparty.org.apache.protocol.HttpContext;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;

@ThreadSafe
public class BasicAsyncRequestProducer
implements HttpAsyncRequestProducer {
    private final HttpHost target;
    private final HttpRequest request;
    private final HttpAsyncContentProducer producer;

    protected BasicAsyncRequestProducer(HttpHost target, HttpEntityEnclosingRequest request, HttpAsyncContentProducer producer) {
        Args.notNull(target, "HTTP host");
        Args.notNull(request, "HTTP request");
        Args.notNull(producer, "HTTP content producer");
        this.target = target;
        this.request = request;
        this.producer = producer;
    }

    public BasicAsyncRequestProducer(HttpHost target, HttpRequest request) {
        HttpEntity entity;
        Args.notNull(target, "HTTP host");
        Args.notNull(request, "HTTP request");
        this.target = target;
        this.request = request;
        this.producer = request instanceof HttpEntityEnclosingRequest ? ((entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null ? (entity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)entity) : new EntityAsyncContentProducer(entity)) : null) : null;
    }

    public synchronized HttpRequest generateRequest() {
        return this.request;
    }

    public HttpHost getTarget() {
        return this.target;
    }

    public synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.producer != null) {
            this.producer.produceContent(encoder, ioctrl);
            if (encoder.isCompleted()) {
                this.producer.close();
            }
        }
    }

    public void requestCompleted(HttpContext context) {
    }

    public void failed(Exception ex) {
    }

    public synchronized boolean isRepeatable() {
        return this.producer == null || this.producer.isRepeatable();
    }

    public synchronized void resetRequest() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public synchronized void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

