/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.AsyncTimeseriesClient;
import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.InternalClient;
import com.alicloud.openservices.tablestore.PrepareCallback;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.TimeseriesClient;
import com.alicloud.openservices.tablestore.core.ResourceManager;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.AbortTransactionRequest;
import com.alicloud.openservices.tablestore.model.AbortTransactionResponse;
import com.alicloud.openservices.tablestore.model.AddDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.AddDefinedColumnResponse;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkExportResponse;
import com.alicloud.openservices.tablestore.model.BulkImportRequest;
import com.alicloud.openservices.tablestore.model.BulkImportResponse;
import com.alicloud.openservices.tablestore.model.CommitTransactionRequest;
import com.alicloud.openservices.tablestore.model.CommitTransactionResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsResponse;
import com.alicloud.openservices.tablestore.model.CreateIndexRequest;
import com.alicloud.openservices.tablestore.model.CreateIndexResponse;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.DeleteDefinedColumnResponse;
import com.alicloud.openservices.tablestore.model.DeleteIndexRequest;
import com.alicloud.openservices.tablestore.model.DeleteIndexResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowColumnIteratorImpl;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetShardIteratorResponse;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordResponse;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.ListStreamResponse;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.StartLocalTransactionRequest;
import com.alicloud.openservices.tablestore.model.StartLocalTransactionResponse;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import com.alicloud.openservices.tablestore.model.UpdateTableResponse;
import com.alicloud.openservices.tablestore.model.WideColumnIterator;
import com.alicloud.openservices.tablestore.model.delivery.CreateDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.CreateDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.delivery.DeleteDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.DeleteDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.delivery.DescribeDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.DescribeDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.delivery.ListDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.ListDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.iterator.BulkExportIterator;
import com.alicloud.openservices.tablestore.model.iterator.GetRangeRowIterator;
import com.alicloud.openservices.tablestore.model.iterator.ParallelScanRowIterator;
import com.alicloud.openservices.tablestore.model.iterator.RowIterator;
import com.alicloud.openservices.tablestore.model.iterator.SearchRowIterator;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.ParallelScanRequest;
import com.alicloud.openservices.tablestore.model.search.ParallelScanResponse;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.model.search.UpdateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.UpdateSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.sql.SQLQueryRequest;
import com.alicloud.openservices.tablestore.model.sql.SQLQueryResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SyncClient
implements SyncClientInterface {
    private InternalClient internalClient;
    private PrepareCallback prepareCallback = new DefaultPrepareCallback();

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName);
    }

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, String stsToken) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, null, null, stsToken);
    }

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, config);
    }

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, config, null, stsToken);
    }

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken, ExecutorService callbackExecutor) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, config, callbackExecutor, stsToken);
    }

    public SyncClient(String endpoint, CredentialsProvider credsProvider, String instanceName, ClientConfiguration config, ResourceManager resourceManager) {
        this.internalClient = new InternalClient(endpoint, credsProvider, instanceName, config, resourceManager);
    }

    SyncClient(InternalClient internalClient) {
        this.internalClient = internalClient;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.internalClient.setExtraHeaders(extraHeaders);
    }

    public String getEndpoint() {
        return this.internalClient.getEndpoint();
    }

    public String getInstanceName() {
        return this.internalClient.getInstanceName();
    }

    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(createTableRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<CreateTableResponse> res = this.internalClient.createTable(createTableRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public ListTableResponse listTable() throws TableStoreException, ClientException {
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<ListTableResponse> res = this.internalClient.listTable(null);
        return this.waitForFuture(res);
    }

    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<DescribeTableResponse> res = this.internalClient.describeTable(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(deleteTableRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<DeleteTableResponse> res = this.internalClient.deleteTable(deleteTableRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<UpdateTableResponse> res = this.internalClient.updateTable(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(createIndexRequest);
        Future<CreateIndexResponse> res = this.internalClient.createIndex(createIndexRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(deleteIndexRequest);
        Future<DeleteIndexResponse> res = this.internalClient.deleteIndex(deleteIndexRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public AddDefinedColumnResponse addDefinedColumn(AddDefinedColumnRequest addDefinedColumnRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(addDefinedColumnRequest);
        Future<AddDefinedColumnResponse> res = this.internalClient.addDefinedColumn(addDefinedColumnRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteDefinedColumnResponse deleteDefinedColumn(DeleteDefinedColumnRequest deleteDefinedColumnRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(deleteDefinedColumnRequest);
        Future<DeleteDefinedColumnResponse> res = this.internalClient.deleteDefinedColumn(deleteDefinedColumnRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetRowResponse getRow(GetRowRequest getRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getRowRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<GetRowResponse> res = this.internalClient.getRow(getRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public PutRowResponse putRow(PutRowRequest putRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(putRowRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<PutRowResponse> res = this.internalClient.putRow(putRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public UpdateRowResponse updateRow(UpdateRowRequest updateRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(updateRowRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<UpdateRowResponse> res = this.internalClient.updateRow(updateRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteRowResponse deleteRow(DeleteRowRequest deleteRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(deleteRowRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<DeleteRowResponse> res = this.internalClient.deleteRow(deleteRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public BatchGetRowResponse batchGetRow(BatchGetRowRequest batchGetRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(batchGetRowRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<BatchGetRowResponse> res = this.internalClient.batchGetRow(batchGetRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public BatchWriteRowResponse batchWriteRow(BatchWriteRowRequest batchWriteRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(batchWriteRowRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<BatchWriteRowResponse> res = this.internalClient.batchWriteRow(batchWriteRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public BulkImportResponse bulkImport(BulkImportRequest bulkImportRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(bulkImportRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<BulkImportResponse> res = this.internalClient.bulkImport(bulkImportRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetRangeResponse getRange(GetRangeRequest getRangeRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getRangeRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<GetRangeResponse> res = this.internalClient.getRange(getRangeRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public BulkExportResponse bulkExport(BulkExportRequest bulkExportRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(bulkExportRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<BulkExportResponse> res = this.internalClient.bulkExport(bulkExportRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public ComputeSplitsBySizeResponse computeSplitsBySize(ComputeSplitsBySizeRequest computeSplitsBySizeRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(computeSplitsBySizeRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<ComputeSplitsBySizeResponse> res = this.internalClient.computeSplitsBySize(computeSplitsBySizeRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public Iterator<Row> createRangeIterator(RangeIteratorParameter rangeIteratorParameter) throws TableStoreException, ClientException {
        return new GetRangeRowIterator(this, rangeIteratorParameter);
    }

    @Override
    public Iterator<Row> createBulkExportIterator(RangeIteratorParameter rangeIteratorParameter) throws TableStoreException, ClientException {
        return new BulkExportIterator(this, rangeIteratorParameter);
    }

    @Override
    public WideColumnIterator createWideColumnIterator(GetRowRequest getRowRequest) throws TableStoreException, ClientException {
        GetRowColumnIteratorImpl getRowColumnIterator = new GetRowColumnIteratorImpl(this.internalClient, getRowRequest);
        if (getRowColumnIterator.isRowExistent()) {
            return new WideColumnIterator(getRowRequest.getRowQueryCriteria().getPrimaryKey(), getRowColumnIterator);
        }
        return null;
    }

    @Override
    public ListStreamResponse listStream(ListStreamRequest listStreamRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(listStreamRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<ListStreamResponse> res = this.internalClient.listStream(listStreamRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(describeStreamRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<DescribeStreamResponse> res = this.internalClient.describeStream(describeStreamRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getShardIteratorRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<GetShardIteratorResponse> res = this.internalClient.getShardIterator(getShardIteratorRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetStreamRecordResponse getStreamRecord(GetStreamRecordRequest getStreamRecordRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getStreamRecordRequest);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<GetStreamRecordResponse> res = this.internalClient.getStreamRecord(getStreamRecordRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public CreateSearchIndexResponse createSearchIndex(CreateSearchIndexRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<CreateSearchIndexResponse> res = this.internalClient.createSearchIndex(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public UpdateSearchIndexResponse updateSearchIndex(UpdateSearchIndexRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<UpdateSearchIndexResponse> res = this.internalClient.updateSearchIndex(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public ListSearchIndexResponse listSearchIndex(ListSearchIndexRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<ListSearchIndexResponse> res = this.internalClient.listSearchIndex(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteSearchIndexResponse deleteSearchIndex(DeleteSearchIndexRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<DeleteSearchIndexResponse> res = this.internalClient.deleteSearchIndex(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public DescribeSearchIndexResponse describeSearchIndex(DescribeSearchIndexRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkStringNotNullAndEmpty(request.getTableName(), "TableName should not be null or empty.");
        Preconditions.checkStringNotNullAndEmpty(request.getIndexName(), "TableName should not be null or empty.");
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<DescribeSearchIndexResponse> res = this.internalClient.describeSearchIndex(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public ComputeSplitsResponse computeSplits(ComputeSplitsRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<ComputeSplitsResponse> res = this.internalClient.computeSplits(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public ParallelScanResponse parallelScan(ParallelScanRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<ParallelScanResponse> res = this.internalClient.parallelScan(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public RowIterator createParallelScanIterator(ParallelScanRequest request) throws TableStoreException, ClientException {
        return new ParallelScanRowIterator(this, request);
    }

    @Override
    public RowIterator createSearchIterator(SearchRequest request) throws TableStoreException, ClientException {
        return new SearchRowIterator(this, request);
    }

    @Override
    public SearchResponse search(SearchRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<SearchResponse> res = this.internalClient.search(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public StartLocalTransactionResponse startLocalTransaction(StartLocalTransactionRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<StartLocalTransactionResponse> res = this.internalClient.startLocalTransaction(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public CommitTransactionResponse commitTransaction(CommitTransactionRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<CommitTransactionResponse> res = this.internalClient.commitTransaction(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public AbortTransactionResponse abortTransaction(AbortTransactionRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<AbortTransactionResponse> res = this.internalClient.abortTransaction(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public CreateDeliveryTaskResponse createDeliveryTask(CreateDeliveryTaskRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<CreateDeliveryTaskResponse> res = this.internalClient.createDeliveryTask(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteDeliveryTaskResponse deleteDeliveryTask(DeleteDeliveryTaskRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<DeleteDeliveryTaskResponse> res = this.internalClient.deleteDeliveryTask(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public DescribeDeliveryTaskResponse describeDeliveryTask(DescribeDeliveryTaskRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<DescribeDeliveryTaskResponse> res = this.internalClient.describeDeliveryTask(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public ListDeliveryTaskResponse listDeliveryTask(ListDeliveryTaskRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<ListDeliveryTaskResponse> res = this.internalClient.listDeliveryTask(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public SQLQueryResponse sqlQuery(SQLQueryRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(this.prepareCallback);
        this.prepareCallback.onPrepare();
        Future<SQLQueryResponse> res = this.internalClient.sqlQuery(request, null);
        return this.waitForFuture(res);
    }

    private <Res> Res waitForFuture(Future<Res> f) {
        try {
            return f.get(this.internalClient.getClientConfig().getSyncClientWaitFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
        catch (TimeoutException e) {
            throw new ClientException("Wait future timeout", e);
        }
    }

    @Override
    public AsyncClientInterface asAsyncClient() {
        return new AsyncClient(this.internalClient);
    }

    public TimeseriesClient asTimeseriesClient() {
        return new TimeseriesClient(this.internalClient);
    }

    public AsyncTimeseriesClient asAsyncTimeseriesClient() {
        return new AsyncTimeseriesClient(this.internalClient);
    }

    @Override
    public void shutdown() {
        this.internalClient.shutdown();
    }

    public void setPrepareCallback(PrepareCallback cb) {
        this.prepareCallback = cb;
    }

    public void setCredentials(ServiceCredentials credentials) {
        this.internalClient.setCredentials(credentials);
    }

    @Override
    public void switchCredentialsProvider(CredentialsProvider newCrdsProvider) {
        this.internalClient.switchCredentialsProvider(newCrdsProvider);
    }

    public class DefaultPrepareCallback
    implements PrepareCallback {
        @Override
        public void onPrepare() {
        }
    }
}

