/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.ResponseContentWithMeta;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.http.ExecutionContext;
import com.alicloud.openservices.tablestore.core.http.ResponseHandler;
import com.alicloud.openservices.tablestore.core.http.ResponseMessage;
import com.alicloud.openservices.tablestore.core.protocol.ResultParseException;
import com.alicloud.openservices.tablestore.core.protocol.ResultParser;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.aliyun.ots.thirdparty.org.apache.http.ContentTooLongException;
import com.aliyun.ots.thirdparty.org.apache.http.HttpEntity;
import com.aliyun.ots.thirdparty.org.apache.http.HttpResponse;
import com.aliyun.ots.thirdparty.org.apache.http.entity.ContentType;
import com.aliyun.ots.thirdparty.org.apache.http.nio.ContentDecoder;
import com.aliyun.ots.thirdparty.org.apache.http.nio.IOControl;
import com.aliyun.ots.thirdparty.org.apache.http.nio.entity.ContentBufferEntity;
import com.aliyun.ots.thirdparty.org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.aliyun.ots.thirdparty.org.apache.http.nio.util.ByteBufferAllocator;
import com.aliyun.ots.thirdparty.org.apache.http.nio.util.ContentInputBuffer;
import com.aliyun.ots.thirdparty.org.apache.http.nio.util.HeapByteBufferAllocator;
import com.aliyun.ots.thirdparty.org.apache.http.nio.util.SimpleInputBuffer;
import com.aliyun.ots.thirdparty.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.List;

public abstract class ResponseConsumer<Res>
extends AbstractAsyncResponseConsumer<Res> {
    protected static final int BUFFER_SIZE = 4096;
    protected volatile HttpResponse httpResponse;
    protected volatile SimpleInputBuffer buf;
    protected ResultParser resultParser;
    protected ExecutionContext context;
    protected TraceLogger traceLogger;
    protected RetryStrategy retry;
    protected Res lastResult;

    public ResponseConsumer(ResultParser resultParser, TraceLogger traceLogger, RetryStrategy retry, Res lastResult) {
        this.resultParser = resultParser;
        this.traceLogger = traceLogger;
        this.retry = retry;
        this.lastResult = lastResult;
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.httpResponse = response;
    }

    protected abstract Res parseResult() throws Exception;

    protected Res buildResult(HttpContext context) throws Exception {
        if (LogUtil.LOG.isDebugEnabled()) {
            LogUtil.LOG.debug("TraceId:" + this.traceLogger.getTraceId() + "\t" + "ResponseReveived");
        }
        this.traceLogger.addEventTime("ResponseReveived", System.currentTimeMillis());
        Res result = this.parseResult();
        return result;
    }

    protected ResponseContentWithMeta getResponseContentWithMeta() throws Exception {
        ResponseMessage response = new ResponseMessage(this.httpResponse);
        String traceInfo = response.getHeader("x-ots-traceinfo");
        if (traceInfo != null && LogUtil.LOG.isInfoEnabled()) {
            LogUtil.LOG.info("TraceId:" + this.traceLogger.getTraceId() + "\t" + "ServerTraceInfo:" + traceInfo);
        }
        try {
            List<ResponseHandler> responseHandlers = this.context.getResponseHandlers();
            for (ResponseHandler h : responseHandlers) {
                h.handle(response);
            }
            ResponseContentWithMeta responseContent = (ResponseContentWithMeta)this.resultParser.getObject(response);
            this.closeResponseSilently(response);
            return responseContent;
        }
        catch (ResultParseException e) {
            this.closeResponseSilently(response);
            ClientException ex = new ClientException("Failed to parse response as protocol buffer message.", e);
            throw ex;
        }
        catch (Exception ex) {
            this.closeResponseSilently(response);
            throw ex;
        }
    }

    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.httpResponse.setEntity((HttpEntity)new ContentBufferEntity(entity, (ContentInputBuffer)this.buf));
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Preconditions.checkNotNull(this.buf, "Content buffer should not be null.");
        this.buf.consumeContent(decoder);
    }

    protected void releaseResources() {
        this.httpResponse = null;
        this.buf = null;
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

