/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.aliyun.ots.thirdparty.org.apache.http.Header;
import com.aliyun.ots.thirdparty.org.apache.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ResponseMessage {
    private HttpResponse response;
    private Map<String, String> lowerCaseHeaders;
    private static final int HTTP_SUCCESS_STATUS_CODE = 200;

    public ResponseMessage(HttpResponse response) {
        this.response = response;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getHeader(String header) {
        this.initHeaderMap();
        return this.lowerCaseHeaders.get(header.toLowerCase());
    }

    public Map<String, String> getLowerCaseHeadersMap() {
        this.initHeaderMap();
        return this.lowerCaseHeaders;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    private void initHeaderMap() {
        if (this.lowerCaseHeaders == null) {
            this.lowerCaseHeaders = new HashMap<String, String>(this.response.getAllHeaders().length);
            for (Header header : this.response.getAllHeaders()) {
                this.lowerCaseHeaders.put(header.getName().toLowerCase(), header.getValue());
            }
        }
    }

    public boolean isSuccessful() {
        return this.getStatusCode() / 100 == 2;
    }

    public InputStream getContent() throws IOException {
        return this.response.getEntity().getContent();
    }

    public void close() throws IOException {
        this.response.getEntity().getContent().close();
    }
}

