/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.Constants;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SearchVariantType {
    public static final byte VT_INTEGER = 0;
    public static final byte VT_DOUBLE = 1;
    public static final byte VT_BOOLEAN = 2;
    public static final byte VT_STRING = 3;

    public static VariantType GetVariantType(byte[] data) {
        if (data[0] == 0) {
            return VariantType.INTEGER;
        }
        if (data[0] == 1) {
            return VariantType.DOUBLE;
        }
        if (data[0] == 2) {
            return VariantType.BOOLEAN;
        }
        if (data[0] == 3) {
            return VariantType.STRING;
        }
        throw new IllegalArgumentException("unknown type: " + data[0]);
    }

    public static long asLong(byte[] data) {
        return ByteBuffer.wrap(data, 1, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static byte[] fromLong(long v) {
        ByteBuffer buffer = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        return buffer.put((byte)0).putLong(v).array();
    }

    public static double asDouble(byte[] data) {
        return ByteBuffer.wrap(data, 1, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    public static byte[] fromDouble(double v) {
        ByteBuffer buffer = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        return buffer.put((byte)1).putDouble(v).array();
    }

    public static String asString(byte[] data) {
        int length = ByteBuffer.wrap(data, 1, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return new String(data, 5, length, Constants.UTF8_CHARSET);
    }

    public static byte[] fromString(String v) {
        byte[] vBytes = v.getBytes(Constants.UTF8_CHARSET);
        ByteBuffer buffer = ByteBuffer.allocate(5 + vBytes.length).order(ByteOrder.LITTLE_ENDIAN);
        return buffer.put((byte)3).putInt(vBytes.length).put(vBytes).array();
    }

    public static boolean asBoolean(byte[] data) {
        return data[1] != 0;
    }

    public static byte[] fromBoolean(boolean v) {
        return new byte[]{2, (byte)(v ? 1 : 0)};
    }

    public static Object getValue(byte[] data) {
        if (data[0] == 0) {
            return SearchVariantType.asLong(data);
        }
        if (data[0] == 1) {
            return SearchVariantType.asDouble(data);
        }
        if (data[0] == 3) {
            return SearchVariantType.asString(data);
        }
        if (data[0] == 2) {
            return SearchVariantType.asBoolean(data);
        }
        throw new IllegalArgumentException("unknown type: " + data[0]);
    }

    public static byte[] toVariant(ColumnValue value) {
        switch (value.getType()) {
            case STRING: {
                return SearchVariantType.fromString(value.asString());
            }
            case INTEGER: {
                return SearchVariantType.fromLong(value.asLong());
            }
            case DOUBLE: {
                return SearchVariantType.fromDouble(value.asDouble());
            }
            case BOOLEAN: {
                return SearchVariantType.fromBoolean(value.asBoolean());
            }
        }
        throw new IllegalArgumentException("unsupported type:" + value.getType().name());
    }

    public static ColumnValue forceConvertToDestColumnValue(byte[] data) throws IOException {
        if (data.length == 0) {
            throw new IOException("data is null");
        }
        ColumnValue columnValue = null;
        if (data[0] == 0) {
            columnValue = new ColumnValue(SearchVariantType.asLong(data), ColumnType.INTEGER);
        } else if (data[0] == 1) {
            columnValue = new ColumnValue(SearchVariantType.asDouble(data), ColumnType.DOUBLE);
        } else if (data[0] == 3) {
            columnValue = new ColumnValue(SearchVariantType.asString(data), ColumnType.STRING);
        } else if (data[0] == 2) {
            columnValue = new ColumnValue(SearchVariantType.asBoolean(data), ColumnType.BOOLEAN);
        } else {
            throw new IOException("Bug: unsupported data type");
        }
        return columnValue;
    }

    static enum VariantType {
        INTEGER,
        DOUBLE,
        BOOLEAN,
        STRING;

    }
}

