/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.ecosystem.TablestoreSplit;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.iterator.RowIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TablestoreSplitIterator
implements RowIterator {
    private ArrayList<Iterator<Row>> rowIterators = new ArrayList();
    private ArrayList<PrimaryKey> getRows;
    private Iterator<Row> current;
    private int iteratorIndex;
    private boolean needFetchSingleRow;

    public TablestoreSplitIterator(SyncClientInterface client, List<TablestoreSplit.PkRange> pkRanges, String tableName, List<String> requiredColumns) {
        BatchGetRowRequest request;
        BatchGetRowResponse response;
        for (TablestoreSplit.PkRange pkRange : pkRanges) {
            if (pkRange.getEqual() == null) {
                Iterator<Row> rows = this.generateIterator(client, pkRange.getBegin(), pkRange.getEnd(), tableName, requiredColumns);
                this.rowIterators.add(rows);
                continue;
            }
            this.needFetchSingleRow = true;
        }
        if (this.needFetchSingleRow && (response = client.batchGetRow(request = this.buildBatchGet(pkRanges, tableName))).getFailedRows().isEmpty()) {
            ArrayList<Row> rowCollction = new ArrayList<Row>();
            for (BatchGetRowResponse.RowResult result : response.getSucceedRows()) {
                if (result.getRow() == null) continue;
                rowCollction.add(result.getRow());
            }
            if (rowCollction.size() > 0) {
                this.rowIterators.add(rowCollction.iterator());
            }
        }
        if (this.rowIterators.size() > 0) {
            this.iteratorIndex = 0;
            this.current = this.rowIterators.get(this.iteratorIndex);
        } else {
            this.iteratorIndex = 0;
            this.current = null;
        }
    }

    private BatchGetRowRequest buildBatchGet(List<TablestoreSplit.PkRange> pkRanges, String tableName) {
        BatchGetRowRequest request = new BatchGetRowRequest();
        MultiRowQueryCriteria criteria1 = new MultiRowQueryCriteria(tableName);
        criteria1.setMaxVersions(1);
        for (TablestoreSplit.PkRange range : pkRanges) {
            if (range.getEqual() == null) continue;
            criteria1.addRow(range.getEqual());
            request.addMultiRowQueryCriteria(criteria1);
        }
        return request;
    }

    private Iterator<Row> generateIterator(SyncClientInterface client, PrimaryKey begin, PrimaryKey end, String tableName, List<String> requiredColumns) {
        RangeIteratorParameter rangeIteratorParameter = new RangeIteratorParameter(tableName);
        rangeIteratorParameter.setInclusiveStartPrimaryKey(begin);
        rangeIteratorParameter.setExclusiveEndPrimaryKey(end);
        rangeIteratorParameter.setMaxVersions(1);
        if (requiredColumns != null && !requiredColumns.isEmpty()) {
            for (String col : requiredColumns) {
                rangeIteratorParameter.addColumnsToGet(col);
            }
        } else {
            String defaultString = begin.getPrimaryKeyColumn(0).getName();
            rangeIteratorParameter.addColumnsToGet(defaultString);
        }
        if (requiredColumns != null && !requiredColumns.isEmpty()) {
            return client.createBulkExportIterator(rangeIteratorParameter);
        }
        return client.createRangeIterator(rangeIteratorParameter);
    }

    @Override
    public long getTotalCount() {
        return -1L;
    }

    @Override
    public boolean hasNext() {
        return this.current != null && (this.current.hasNext() || this.iteratorIndex < this.rowIterators.size() - 1);
    }

    @Override
    public Row next() {
        if (this.current == null) {
            return null;
        }
        if (!this.current.hasNext()) {
            while (!this.current.hasNext() && this.iteratorIndex < this.rowIterators.size() - 1) {
                ++this.iteratorIndex;
                this.current = this.rowIterators.get(this.iteratorIndex);
            }
        }
        return this.current.next();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }
}

