/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.DataBlockType;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Response;
import java.nio.ByteBuffer;

public class BulkExportResponse
extends Response {
    private ConsumedCapacity consumedCapacity;
    private ByteBuffer rows;
    private PrimaryKey nextStartPrimaryKey;
    private byte[] nextToken;
    private DataBlockType dataBlockType = DataBlockType.DBT_PLAIN_BUFFER;
    private long bodyBytes;

    public BulkExportResponse(Response meta, ConsumedCapacity consumedCapacity) {
        super(meta);
        Preconditions.checkNotNull(consumedCapacity);
        this.consumedCapacity = consumedCapacity;
    }

    public void setRows(ByteBuffer rows) {
        this.rows = rows;
    }

    public void setNextStartPrimaryKey(PrimaryKey nextStartPrimaryKey) {
        this.nextStartPrimaryKey = nextStartPrimaryKey;
    }

    public void setDataBlockType(DataBlockType dataBlockType) {
        this.dataBlockType = dataBlockType;
    }

    public DataBlockType getDataBlockType() {
        return this.dataBlockType;
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public ByteBuffer getRows() {
        return this.rows;
    }

    public PrimaryKey getNextStartPrimaryKey() {
        return this.nextStartPrimaryKey;
    }

    public byte[] getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(byte[] nextToken) {
        this.nextToken = nextToken;
    }

    public boolean hasNextToken() {
        return this.nextToken != null && this.nextToken.length > 0;
    }

    public long getBodyBytes() {
        return this.bodyBytes;
    }

    public void setBodyBytes(long bodyBytes) {
        this.bodyBytes = bodyBytes;
    }
}

