/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;

public class TimeRange {
    private long start = 0L;
    private long end = Long.MAX_VALUE;
    private boolean eternal = false;

    public TimeRange() {
        this.eternal = true;
    }

    public TimeRange(long start) {
        Preconditions.checkArgument(start >= 0L, "The start timestamp should be greater than 0.");
        this.start = start;
    }

    public TimeRange(long start, long end) {
        Preconditions.checkArgument(end > start, "end is smaller than start");
        Preconditions.checkArgument(start >= 0L, "The start timestamp should be greater than 0.");
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean withinTimeRange(long timestamp) {
        if (this.eternal) {
            return true;
        }
        return this.start <= timestamp && timestamp < this.end;
    }

    public int compare(long timestamp) {
        if (timestamp < this.start) {
            return -1;
        }
        if (timestamp >= this.end) {
            return 1;
        }
        return 0;
    }

    public boolean containsOnlyOneVersion() {
        return this.end - this.start == 1L;
    }

    public int hashCode() {
        return (int)(this.start * 31L + this.end);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimeRange)) {
            return false;
        }
        TimeRange target = (TimeRange)o;
        return target.start == this.start && target.end == this.end;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("start=");
        sb.append(this.start);
        sb.append(", end=");
        sb.append(this.end);
        return sb.toString();
    }
}

