/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.InternalClient;
import com.alicloud.openservices.tablestore.core.utils.Pair;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowRangeColumnIteratorImpl;
import com.alicloud.openservices.tablestore.model.WideColumnIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class WideRowIterator
implements Iterator<WideColumnIterator> {
    private InternalClient internalClient;
    private RangeIteratorParameter parameter;
    private PrimaryKey nextStartPrimaryKey;
    private byte[] nextToken;
    private int totalCount;
    private int bufferSize;
    private int rowsRead = 0;
    private RowRangeColumnIteratorImpl columnIterator;
    private Iterator<Pair<Row, Boolean>> rowIterator;

    public WideRowIterator(InternalClient client, RangeIteratorParameter rangeIteratorParameter) {
        this.internalClient = client;
        this.parameter = rangeIteratorParameter;
        this.totalCount = rangeIteratorParameter.getMaxCount();
        this.bufferSize = rangeIteratorParameter.getBufferSize();
        if (this.bufferSize == -1) {
            this.bufferSize = this.totalCount;
        } else if (this.totalCount != -1 && this.bufferSize > this.totalCount) {
            this.bufferSize = this.totalCount;
        }
        this.columnIterator = new RowRangeColumnIteratorImpl(this, null, new ArrayList().iterator(), true);
        this.nextStartPrimaryKey = this.parameter.getInclusiveStartPrimaryKey();
    }

    private GetRangeRequest buildRequest() {
        RangeRowQueryCriteria criteria = new RangeRowQueryCriteria(this.parameter.getTableName());
        this.parameter.copyTo(criteria);
        criteria.setDirection(this.parameter.getDirection());
        criteria.setInclusiveStartPrimaryKey(this.nextStartPrimaryKey);
        criteria.setExclusiveEndPrimaryKey(this.parameter.getExclusiveEndPrimaryKey());
        criteria.setToken(this.nextToken);
        if (this.bufferSize > 0) {
            if (this.totalCount != -1 && this.totalCount - this.rowsRead < this.bufferSize) {
                criteria.setLimit(this.totalCount - this.rowsRead);
            } else {
                criteria.setLimit(this.bufferSize);
            }
        }
        return new GetRangeRequest(criteria);
    }

    void fetchData() {
        GetRangeResponse result = null;
        try {
            result = this.internalClient.getRange(this.buildRequest(), null).get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        int idx = 0;
        List<Row> rows = result.getRows();
        if (!this.columnIterator.isComplete() && rows.size() > 0 && rows.get(0).getPrimaryKey().equals(this.columnIterator.getPrimaryKey())) {
            this.columnIterator.setColumnIterator(Arrays.asList(rows.get(0).getColumns()).iterator());
            idx = 1;
        }
        ArrayList<Pair<Row, Boolean>> rowsWithStatus = new ArrayList<Pair<Row, Boolean>>();
        for (int i = idx; i < rows.size(); ++i) {
            if (i == rows.size() - 1 && rows.get(i).getPrimaryKey().equals(result.getNextStartPrimaryKey())) {
                rowsWithStatus.add(new Pair<Row, Boolean>(rows.get(i), false));
                continue;
            }
            rowsWithStatus.add(new Pair<Row, Boolean>(rows.get(i), true));
            ++this.rowsRead;
        }
        this.rowIterator = rowsWithStatus.iterator();
        this.nextStartPrimaryKey = result.getNextStartPrimaryKey();
        this.nextToken = result.getNextToken();
        if (!this.columnIterator.isComplete() && !this.columnIterator.getPrimaryKey().equals(this.nextStartPrimaryKey)) {
            this.columnIterator.setComplete(true);
            ++this.rowsRead;
        }
    }

    @Override
    public boolean hasNext() {
        this.columnIterator.close();
        while (this.nextStartPrimaryKey != null && !this.rowIterator.hasNext() && this.rowsRead < this.totalCount) {
            this.fetchData();
        }
        return this.rowIterator.hasNext();
    }

    @Override
    public WideColumnIterator next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<Row, Boolean> rowWithStatus = this.rowIterator.next();
        Row row = rowWithStatus.getFirst();
        boolean complete = rowWithStatus.getSecond();
        this.columnIterator = new RowRangeColumnIteratorImpl(this, row.getPrimaryKey(), Arrays.asList(row.getColumns()).iterator(), complete);
        return new WideColumnIterator(row.getPrimaryKey(), this.columnIterator);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

