/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.model.search.FieldType;
import com.alicloud.openservices.tablestore.model.search.IndexOptions;
import com.alicloud.openservices.tablestore.model.search.JsonType;
import com.alicloud.openservices.tablestore.model.search.analysis.AnalyzerParameter;
import com.alicloud.openservices.tablestore.model.search.analysis.FuzzyAnalyzerParameter;
import com.alicloud.openservices.tablestore.model.search.analysis.SingleWordAnalyzerParameter;
import com.alicloud.openservices.tablestore.model.search.analysis.SplitAnalyzerParameter;
import com.alicloud.openservices.tablestore.model.search.vector.VectorOptions;
import java.util.Collections;
import java.util.List;

public class FieldSchema
implements Jsonizable {
    private String fieldName;
    private FieldType fieldType;
    private Boolean index = true;
    private IndexOptions indexOptions;
    private Boolean enableHighlighting;
    private Analyzer analyzer;
    private AnalyzerParameter analyzerParameter;
    private Boolean enableSortAndAgg;
    private Boolean store;
    private Boolean isArray;
    private List<FieldSchema> subFieldSchemas;
    private Boolean isVirtualField;
    private List<String> sourceFieldNames;
    private List<String> dateFormats;
    private VectorOptions vectorOptions;
    private JsonType jsonType;

    public FieldSchema(String fieldName, FieldType fieldType) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldSchema setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public FieldSchema setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public Boolean isIndex() {
        return this.index;
    }

    public FieldSchema setIndex(boolean index) {
        this.index = index;
        return this;
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public FieldSchema setIndexOptions(IndexOptions indexOptions) {
        this.indexOptions = indexOptions;
        return this;
    }

    public FieldSchema setEnableHighlighting(boolean enableHighlighting) {
        this.enableHighlighting = enableHighlighting;
        return this;
    }

    public Boolean isEnableHighlighting() {
        return this.enableHighlighting;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public FieldSchema setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public AnalyzerParameter getAnalyzerParameter() {
        return this.analyzerParameter;
    }

    public FieldSchema setAnalyzerParameter(AnalyzerParameter analyzerParameter) {
        this.analyzerParameter = analyzerParameter;
        return this;
    }

    public Boolean isEnableSortAndAgg() {
        return this.enableSortAndAgg;
    }

    public FieldSchema setEnableSortAndAgg(boolean enableSortAndAgg) {
        this.enableSortAndAgg = enableSortAndAgg;
        return this;
    }

    public Boolean isStore() {
        return this.store;
    }

    public FieldSchema setStore(Boolean store) {
        this.store = store;
        return this;
    }

    public Boolean isArray() {
        return this.isArray;
    }

    public FieldSchema setIsArray(boolean array) {
        this.isArray = array;
        return this;
    }

    public List<FieldSchema> getSubFieldSchemas() {
        return this.subFieldSchemas;
    }

    public FieldSchema setSubFieldSchemas(List<FieldSchema> subFieldSchemas) {
        this.subFieldSchemas = subFieldSchemas;
        return this;
    }

    public Boolean isVirtualField() {
        return this.isVirtualField;
    }

    public FieldSchema setVirtualField(Boolean virtualField) {
        this.isVirtualField = virtualField;
        return this;
    }

    public List<String> getSourceFieldNames() {
        return this.sourceFieldNames;
    }

    public FieldSchema setSourceFieldName(String sourceFieldName) {
        this.sourceFieldNames = Collections.singletonList(sourceFieldName);
        return this;
    }

    public FieldSchema setSourceFieldNames(List<String> sourceFieldNames) {
        this.sourceFieldNames = sourceFieldNames;
        return this;
    }

    public List<String> getDateFormats() {
        return this.dateFormats;
    }

    public FieldSchema setDateFormats(List<String> dateFormats) {
        this.dateFormats = dateFormats;
        return this;
    }

    public VectorOptions getVectorOptions() {
        return this.vectorOptions;
    }

    public FieldSchema setVectorOptions(VectorOptions vectorOptions) {
        this.vectorOptions = vectorOptions;
        return this;
    }

    public JsonType getJsonType() {
        return this.jsonType;
    }

    public FieldSchema setJsonType(JsonType jsonType) {
        this.jsonType = jsonType;
        return this;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        String sourceField;
        sb.append('{');
        sb.append(newline);
        sb.append("\"FieldName\": \"");
        sb.append(this.fieldName);
        sb.append("\"");
        sb.append(",");
        sb.append(newline);
        if (this.fieldType != null) {
            sb.append("\"FieldType\": \"");
            sb.append(this.fieldType.name());
            sb.append("\"");
            sb.append(",");
            sb.append(newline);
        }
        if (this.index != null) {
            sb.append("\"Index\": ");
            sb.append(this.index.toString());
            sb.append(",");
            sb.append(newline);
        }
        if (this.indexOptions != null) {
            sb.append("\"IndexOptions\": ");
            sb.append(this.indexOptions.toString());
            sb.append(",");
            sb.append(newline);
        }
        if (this.analyzer != null) {
            sb.append("\"Analyzer\": \"");
            sb.append(this.analyzer.toString());
            sb.append("\",");
            sb.append(newline);
            if (this.analyzerParameter != null) {
                if (this.analyzer == Analyzer.SingleWord && this.analyzerParameter instanceof SingleWordAnalyzerParameter) {
                    sb.append("\"AnalyzerParameter\": {");
                    sb.append("\"CaseSensitive\": ");
                    sb.append(((SingleWordAnalyzerParameter)this.analyzerParameter).isCaseSensitive());
                    sb.append(", \"DelimitWord\": ");
                    sb.append(((SingleWordAnalyzerParameter)this.analyzerParameter).isDelimitWord());
                    sb.append("},");
                    sb.append(newline);
                } else if (this.analyzer == Analyzer.Split && this.analyzerParameter instanceof SplitAnalyzerParameter) {
                    String delimiter = ((SplitAnalyzerParameter)this.analyzerParameter).getDelimiter();
                    sb.append("\"AnalyzerParameter\": {");
                    sb.append("\"Delimiter\": ");
                    sb.append(delimiter == null ? "null" : "\"" + delimiter + "\"");
                    sb.append(", \"CaseSensitive\": ");
                    sb.append(((SplitAnalyzerParameter)this.analyzerParameter).isCaseSensitive());
                    sb.append("},");
                    sb.append(newline);
                } else if (this.analyzer == Analyzer.Fuzzy && this.analyzerParameter instanceof FuzzyAnalyzerParameter) {
                    sb.append("\"AnalyzerParameter\": {");
                    sb.append("\"MinChars\": ");
                    sb.append(((FuzzyAnalyzerParameter)this.analyzerParameter).getMinChars());
                    sb.append(", \"MaxChars\": ");
                    sb.append(((FuzzyAnalyzerParameter)this.analyzerParameter).getMaxChars());
                    sb.append(", \"CaseSensitive\": ");
                    sb.append(((FuzzyAnalyzerParameter)this.analyzerParameter).isCaseSensitive());
                    sb.append("},");
                    sb.append(newline);
                }
            }
        }
        if (this.enableSortAndAgg != null) {
            sb.append("\"EnableSortAndAgg\": ");
            sb.append(this.enableSortAndAgg.toString());
            sb.append(",");
            sb.append(newline);
        }
        if (this.enableHighlighting != null) {
            sb.append("\"EnableHighlighting\": ");
            sb.append(this.enableHighlighting.toString());
            sb.append(",");
            sb.append(newline);
        }
        if (this.store != null) {
            sb.append("\"Store\": ");
            sb.append(this.store.toString());
            sb.append(",");
            sb.append(newline);
        }
        if (this.isArray != null) {
            sb.append("\"IsArray\": ");
            sb.append(this.isArray.toString());
            sb.append(",");
            sb.append(newline);
        }
        sb.append("\"SubFieldSchemas\": [");
        if (this.subFieldSchemas != null) {
            for (int i = 0; i < this.subFieldSchemas.size(); ++i) {
                FieldSchema schema = this.subFieldSchemas.get(i);
                schema.jsonize(sb, newline);
                if (i == this.subFieldSchemas.size() - 1) continue;
                sb.append(", ");
                sb.append(newline);
            }
        }
        sb.append("]");
        if (this.isVirtualField != null) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"IsVirtualField\": ");
            sb.append(this.isVirtualField);
        }
        if (this.sourceFieldNames != null) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"SourceFieldNames\": [");
            for (int i = 0; i < this.sourceFieldNames.size(); ++i) {
                sourceField = this.sourceFieldNames.get(i);
                sb.append("\"").append(sourceField).append("\"");
                if (i == this.sourceFieldNames.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateFormats != null) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"DateFormats\": [");
            for (int i = 0; i < this.dateFormats.size(); ++i) {
                sourceField = this.dateFormats.get(i);
                sb.append("\"").append(sourceField).append("\"");
                if (i == this.dateFormats.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.vectorOptions != null) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"VectorOptions\": ");
            sb.append(newline);
            this.vectorOptions.jsonize(sb, newline);
        }
        if (this.jsonType != null) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"JsonType\": ");
            sb.append("\"").append(this.jsonType.name()).append("\"");
        }
        sb.append(newline);
        sb.append("}");
    }

    public static enum Analyzer {
        SingleWord("single_word"),
        MaxWord("max_word"),
        MinWord("min_word"),
        Split("split"),
        Fuzzy("fuzzy");

        private final String value;

        private Analyzer(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Analyzer fromString(String value) {
            if (value.equals(SingleWord.toString())) {
                return SingleWord;
            }
            if (value.equals(MaxWord.toString())) {
                return MaxWord;
            }
            if (value.equals(MinWord.toString())) {
                return MinWord;
            }
            if (value.equals(Split.toString())) {
                return Split;
            }
            if (value.equals(Fuzzy.toString())) {
                return Fuzzy;
            }
            throw new ClientException("Unknown analyzer");
        }
    }
}

