/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alicloud.openservices.tablestore.core.utils.NumberUtils;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.QueryFlowWeight;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class UpdateSearchIndexRequest
implements Request {
    private String tableName;
    private String indexName;
    private String switchIndexName;
    private List<QueryFlowWeight> queryFlowWeight;
    private Integer timeToLive;
    private List<FieldSchema> addedFieldSchemas;

    public UpdateSearchIndexRequest(String tableName, String indexName) {
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public UpdateSearchIndexRequest(String tableName, String indexName, String switchIndexName) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.switchIndexName = switchIndexName;
    }

    public UpdateSearchIndexRequest(String tableName, String indexName, List<QueryFlowWeight> queryFlowWeight) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.queryFlowWeight = queryFlowWeight;
    }

    public String getTableName() {
        return this.tableName;
    }

    public UpdateSearchIndexRequest setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public UpdateSearchIndexRequest setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public String getSwitchIndexName() {
        return this.switchIndexName;
    }

    public UpdateSearchIndexRequest setSwitchIndexName(String switchIndexName) {
        this.switchIndexName = switchIndexName;
        return this;
    }

    public List<QueryFlowWeight> getQueryFlowWeight() {
        return this.queryFlowWeight;
    }

    public UpdateSearchIndexRequest setQueryFlowWeight(List<QueryFlowWeight> queryFlowWeight) {
        this.queryFlowWeight = queryFlowWeight;
        return this;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public UpdateSearchIndexRequest setTimeToLiveInDays(int days) {
        this.setTimeToLive(days, TimeUnit.DAYS);
        return this;
    }

    public UpdateSearchIndexRequest setTimeToLive(int timeToLive, TimeUnit timeUnit) {
        Preconditions.checkArgument(timeToLive > 0 || timeToLive == -1, "The value of timeToLive can be -1 or any positive value.");
        if (timeToLive == -1) {
            this.timeToLive = -1;
        } else {
            long seconds = timeUnit.toSeconds(timeToLive);
            this.timeToLive = NumberUtils.longToInt(seconds);
        }
        return this;
    }

    public List<FieldSchema> getAddedFieldSchemas() {
        return this.addedFieldSchemas;
    }

    public UpdateSearchIndexRequest setAddedFieldSchemas(List<FieldSchema> addedFieldSchemas) {
        if (this.addedFieldSchemas == null) {
            this.addedFieldSchemas = new ArrayList<FieldSchema>();
        }
        this.addedFieldSchemas.addAll(addedFieldSchemas);
        return this;
    }

    @Override
    public String getOperationName() {
        return "UpdateSearchIndex";
    }
}

